import jebl.math.Random;

import java.util.List;
import java.util.ArrayList;

/**
 * @author rambaut
 *         Date: Dec 13, 2005
 *         Time: 10:15:46 PM
 */
public class Mutator {

	private final int sequenceLength = source.length();
	private final int observedMutationCount = 70;
	private final int populationCount = 12;
	private final double mutationRate = observedMutationCount / (observedMutationCount * populationCount);

	private final int repeatCount = 1000000;

	public Mutator() {
		System.out.println("Sequence Length: " + sequenceLength);
		System.out.println("Observed Mutations: " + observedMutationCount);
		System.out.println("Populations: " + populationCount);
		System.out.println("Mutation Rate: " + mutationRate);

		int[] betweenBlockCounts = new int[12];
		int[] withinBlockCounts = new int[4];

		List<Integer>[] mutations = new List[populationCount];
		for (int i = 0; i < populationCount; i++) {
			mutations[i] = new ArrayList<Integer>();
		}

		for (int k = 0; k < repeatCount; k++) {
			for (int i = 0; i < populationCount; i++) {
				mutations[i].clear();
				for (int j = 0; j < sequenceLength; j++) {
					if (Random.nextDouble() < mutationRate) {
						mutations[i].add(j);
					}
				}
			}

			
		}

	}


	public static void main(String[] argv) {
		new Mutator();
	}

	public final static String source = "ACGAAGACAAACAAACCATTATTATCATTAAAAGGCTCAGGAGAAACTTTA" +
			"ACAGTAATCAAAATGTCTGTTACAGTCAAGAGAATCATTGACAACACAGTCATAGTTCCAAAACTTCCTG" +
			"CAAATGAGGATCCAGTGGAATACCCGGCAGATTACTTCAGAAAATCAAAGGAGATTCCTCTTTACATCAA" +
			"TACTACAAAAAGTTTGTCAGATCTAAGAGGATATGTCTACCAAGGCCTCAAATCCGGAAATGTATCAATC" +
			"ATACATGTCAACAGCTACTTGTATGGAGCATTGAAGGACATCCGGGGTAAGTTGGATAAAGATTGGTCAA" +
			"GTTTCGGAATAAACATCGGGAAGGCAGGGGATACAATCGGAATATTTGACCTTGTATCCTTGAAAGCCCT" +
			"GGACGGTGTACTTCCAGATGGAGTATCGGATGCTTCCAGAACCAGCGCAGATGACAAATGGTTGCCTTTG" +
			"TATCTACTTGGCTTATACAGAGTGGGCAGAACACAAATGCCTGAATACAGAAAAAGGCTCATGGATGGGC" +
			"TGACAAATCAATGCAAAATGATCAATGAACAGTTTGAACCTCTTGTGCCAGAAGGTCGTGACATTTTTGA" +
			"TGTGTGGGGAAATGACAGTAATTACACAAAAATTGTCGCTGCAGTGGACATGTTCTTCCACATGTTCAAA" +
			"AAACATGAATGTGCCTCGTTCAGATACGGAACTATTGTTTCCAGATTCAAAGATTGTGCTGCATTGGCAA" +
			"CATTTGGACACCTCTGCAAAATAACCGGAATGTCTACAGAAGATGTGACGACCTGGATCTTGAACCGAGA" +
			"AGTTGCAGATGAGATGGTCCAAATGATGCTTCCAGGCCAAGAAATTGACAAGGCTGATTCATACATGCCT" +
			"TATTTGATCGACTTTGGATTGTCTTCTAAGTCTCCATATTCTTCCGTCAAAAACCCTGCCTTCCACTTCT" +
			"GGGGGCAATTGACAGCTCTTCTGCTCAGATCCACCAGAGCAAGGAATGCCCGACAGCCTGATGACATTGA" +
			"GTATACATCTCTTACTACAGCAGGTTTGTTGTACGCTTATGCAGTAGGATCCTCTGCTGACTTGGCACAA" +
			"CAGTTTTGTGTTGGAGATAGCAAATACACTCCAGATGATAGTACCGGAGGATTGACGACTAATGCACCGC" +
			"CACAAGGCAGAGATGTGGTCGAATGGCTCGGATGGTTTGAAGATCAAAACAGAAAACCGACTCCTGATAT" +
			"GATGCAGTATGCGAAACGAGCAGTCATGTCACTGCAAGGCCTAAGAGAGAAGACAATTGGCAAGTATGCT" +
			"AAGTCAGAGTTTGACAAATGACCCTATAATTCTCAGATCACCTATTATATATTATGCTACATATGAAAAA" +
			"AACTAACAGATATCATGGATAATCTCACAAAAGTTCGTGAGTATCTCAAGTCCTATTCTCGTCTAGATCA" +
			"GGCGGTAGGAGAGATAGATGAGATCGAAGCACAACGAGCTGAAAAGTCCAATTATGAGTTGTTCCAAGAG" +
			"GACGGAGTGGAAGAGCATACTAGGCCCTCTTATTTTCAGGCAGCAGATGATTCTGACACAGAATCTGAAC" +
			"CAGAAATTGAAGACAATCAAGGCTTGTATGTACCAGATCCGGAAGCTGAGCAAGTTGAAGGCTTTATACA" +
			"GGGGCCTTTAGATGACTATGCAGATGAGGACGTGGATGTTGTATTCACTTCGGACTGGAAACAGCCTGAG" +
			"CTTGAATCCGACGAGCATGGAAAGACCTTACGGTTGACATTGCCAGAGGGTTTAAGTGGAGAGCAGAAAT" +
			"CCCAGTGGCTTTTGACGATTAAAGCAGTCGTTCAAAGTGCCAAACACTGGAATCTGGCAGAGTGCACATT" +
			"TGAAGCATCGGGAGAAGGGGTCATCATAAAAAAGCGCCAGATAACTCCGGATGTATATAAGGTCACTCCA" +
			"GTGATGAACACACATCCGTACCAATCAGAAGCCGTATCAGATGTTTGGTCTCTCTCAAAGACATCCATGA" +
			"CTTTCCAACCCAAGAAAGCAAGTCTTCAGCCTCTCACCATATCCTTGGATGAATTGTTCTCATCTAGAGG" +
			"AGAATTCATCTCTGTCGGAGGTAACGGACGAATGTCTCATAAAGAGGCCATCCTGCTCGGTCTGAGGTAC" +
			"AAAAAGTTGTACAATCAGGCGAGAGTCAAATATTCTCTGTAGACTATGAAAAAAAGTAACAGATATCACA" +
			"ATCTAAGTGTTATCCCAATCCATTCATCATGAGTTCCTTAAAGAAGATTCTCGGTCTGAAGGGGAAAGGT" +
			"AAGAAATCTAAGAAATTAGGGATCGCACCACCCCCTTATGAAGAGGACACTAACATGGAGTATGCTCCGA" +
			"GCGCTCCAATTGACAAATCCTATTTTGGAGTTGACGAGATGGACACTCATGATCCGAATCAATTAAGATA" +
			"TGAGAAATTCTTCTTTACAGTGAAAATGACGGTTAGATCTAATCGTCCGTTCAGAACATACTCAGATGTG" +
			"GCAGCCGCTGTATCCCATTGGGATCACATGTACATCGGAATGGCAGGGAAACGTCCCTTCTACAAGATCT" +
			"TGGCTTTTTTGGGTTCTTCTAATCTAAAGGCCACTCCAGCGGTATTGGCAGATCAAGGTCAACCAGAGTA" +
			"TCATGCTCACTGTGAAGGCAGGGCTTATTTGCCACACAGAATGGGGAAGACCCCTCCCATGCTCAATGTA" +
			"CCAGAGCACTTCAGAAGACCATTCAATATAGGTCTTTACAAGGGAACGATTGAGCTCACAATGACCATCT" +
			"ACGATGATGAGTCACTGGAAGCAGCTCCTATGATCTGGGATCATTTCAATTCTTCCAAATTTTCTGATTT" +
			"CAGAGAGAAGGCCTTAATGTTTGGCCTGATTGTCGAGAAAAAGGCATCTGGAGCTTGGGTCCTGGATTCT" +
			"GTCAGCCACTTCAAATGAGCTAGTCTAGCTTCCAGCTTCTGAACAATCCCCGGTTTACTCAGTCTCTCCT" +
			"AATTCCAGCCTTTCGAACAACTAATATCCTGTCTTCTCTATCCCGATGAAAAAAACTAACAGAGATCGAT" +
			"CTGTTTCCTTGACACCATGAAGTGCCTTTTGTACTTAGCTTTTTTATTCATCGGGGTGAATTGCAAGTTC" +
			"ACCATAGTTTTTCCACACAACCAAAAAGGAAACTGGAAAAATGTTCCTTCCAATTACCATTATTGCCCGT" +
			"CAAGCTCAGATTTAAATTGGCATAATGACTTAGTAGGCACAGCCTTACAAGTCAAAATGCCCAAGAGTCA" +
			"CAAGGCTATTCAAGCAGACGGTTGGATGTGTCATGCTTCCAAATGGGTCACTACTTGTGATTTCCGCTGG" +
			"TACGGACCGAAGTATATAACACATTCCATCCGATCCTTCACTCCATCTGTAGAACAATGCAAGGAAAGCA" +
			"TTGAACAAACGAAACAAGGAACTTGGCTGAATCCAGGCTTCCCTCCTCAAAGTTGTGGATATGCAACTGT" +
			"GACGGATGCTGAAGCAGCGATTGTCCAGGTGACTCCTCACCATGTGCTTGTTGATGAATACACAGGAGAA" +
			"TGGGTTGATTCACAGTTCATCAACGGAAAATGCAGCAATGACATATGCCCCACTGTCCATAACTCCACAA" +
			"CCTGGCATTCCGACTATAAGGTCAAAGGGCTATGTGATTCTAACCTCATTTCCATGGACATCACCTTCTT" +
			"CTCAGAGGACGGAGAGCTATCATCCCTAGGAAAGAAGGGCACAGGGTTCAGAAGTAACTACTTTGCTTAT" +
			"GAAACTGGAGACAAGGCCTGCAAAATGCAGTACTGCAAGCATTGGGGAGTCAGACTCCCATCAGGTGTCT" +
			"GGTTCGAGATGGCTGATAAGGMTCTCTTTGCTGCAGCCAGATTCCCTGAATGCCCAGAAGGGTCAAGTAT" +
			"CTCTGCTCCATCTCAGACCTCAGTGGATGTAAGTCTCATTCAGGACGTTGAGAGGATCTTGGATTATTCC" +
			"CTCTGCCAAGAAACCTGGAGCAAAATCAGAGCGGGTCTTCCCATCTCTCCAGTGGATCTCAGCTATCTTG" +
			"CTCCTAAAAACCCAGGAACCGGTCCTGTCTTTACCATAATCAATGGTACCCTAAAATACTTTGAGACCAG" +
			"ATACATCAGAGTCGATATTGCTGCTCCAATCCTCTCAAGAATGGTCGGAATGATCAGTGGAACTACCACA" +
			"GAAAGGGTACTGTGGGATGACTGGGCTCCATATGAAGACGTGGAAATTGGACCCAATGGAGTTCTGAGGA" +
			"CCAGTTCAGGATATAAGTTTCCTTTATATATGATTGGACATGGTATGTTGGACTCCGATCTTCATCTTAG" +
			"CTCAAAGGCTCAGGTGTTTGAACATCCTCACATTCAAGACGCTGCTTCGCAGCTTCCTGATGGTGAGACT" +
			"TTATTTTTTGGTGATACTGGGCTATCCAAAAATCCAATCGAGTTTGTAGAAGGTTGGTTCAGTAGTTGGA" +
			"AGAGCTCTATTGCCTCTTTTTTCTTTACCATAGGGTTAATCATTGGACTATTCTTGGTTCTCCGAGTTGG" +
			"TATTTATCTTTGCATTAAATTAAAGCACACCAAGAAAAGACAGATTTATACAGACATAGAGATGAACCGA" +
			"CTTGGAAAGTAACTCAAATCCTGCACAACAGATTCTTCATGTTTGAACCAAATCAACTTGTGATATCATG" +
			"CTCAAAGAGGCCTTAATTATATTTTAATTTTTAATTTTTATGAAAAAAACTAACAGCAATCATGGAAGTC" +
			"CACGATTTTGAGACCGACGAGTTCAATGATTTCAATGAAGATGACTATGCCACAAGAGAATTCCTGAATC" +
			"CCGATGAGCGCATGACGTACTTGAATCATGCTGATTACAATTTGAATTCTCCTCTAATTAGTGATGATAT" +
			"TGACAATTTGATCAGGAAATTCAATTCTCTTCCGATTCCCTCGATGTGGGATAGTAAGAACTGGGATGGA" +
			"GTTCTTGAGATGTTAACATCATGTCAAGCCAATCCCATCTCAACATCTCAGATGCATAAATGGATGGGAA" +
			"GTTGGTTAATGTCTGATAATCATGATGCCAGTCAAGGGTATAGTTTTTTACATGAAGTGGACAAAGAGGC" +
			"AGAAATAACATTTGACGTGGTGGAGACCTTCATCCGCGGCTGGGGCAACAAACCAATTGAATACATCAAA" +
			"AAGGAAAGATGGACTGACTCATTCAAAATTCTCGCTTATTTGTGTCAAAAGTTTTTGGACTTACACAAGT" +
			"TGACATTAATCTTAAATGCTGTCTCTGAGGTGGAATTGCTCAACTTGGCGAGGACTTTCAAAGGCAAAGT" +
			"CAGAAGAAGTTCTCATGGAACGAACATATGCAGGATTAGGGTTCCCAGCTTGGGTCCTACTTTTATTTCA" +
			"GAAGGATGGGCTTACTTCAAGAAACTTGATATTCTAATGGACCGAAACTTTCTGTTAATGGTCAAAGATG" +
			"TGATTATAGGGAGGATGCAAACGGTGCTATCCATGGTATGTAGAATAGACAACCTGTTCTCAGAGCAAGA" +
			"CATCTTCTCCCTTCTAAATATCTACAGAATTGGAGATAAAATTGTGGAGAGGCAGGGAAATTTTTCTTAT" +
			"GACTTGATTAAAATGGTGGAACCGATATGCAACTTGAAGCTGATGAAATTAGCAAGAGAATCAAGGCCTT" +
			"TAGTCCCACAATTCCCTCATTTTGAAAATCATATCAAGACTTCTGTTGATGAAGGGGCAAAAATTGACCG" +
			"AGGTATAAGATTCCTCCATGATCAGATAATGAGTGTGAAAACAGTGGATCTCACACTGGTGATTTATGGA" +
			"TCGTTCAGACATTGGGGTCATCCTTTTATAGATTATTACACTGGACTAGAAAAATTACATTCCCAAGTAA" +
			"CCATGAAGAAAGATATTGATGTGTCATATGCAAAAGCACTTGCAAGTGATTTAGCTCGGATTGTTCTATT" +
			"TCAACAGTTCAATGATCATAAAAAGTGGTTCGTGAATGGAGACTTGCTCCCTCATGATCATCCCTTTAAA" +
			"AGTCATGTTAAAGAAAATACATGGCCTACAGCTGCTCAAGTTCAAGATTTTGGAGATAAATGGCATGAAC" +
			"TTCCGCTGATTAAATGTTTTGAAATACCCGACTTACTAGACCCATCGATAATATACTCTGACAAAAGTCA" +
			"TTCAATGAATAGGTCAGAGGTGTTGAAACATGTCCGAATGAATCCGAACACTCCTATCCCTAGTAAAAAG" +
			"GTGTTGCAGACTATGTTGGACACAAAGGCTACCAATTGGAAAGAATTTCTTAAAGAGATTGATGAGAAGG" +
			"GCTTAGATGATGATGATCTAATTATTGGTCTTAAAGGAAAGGAGAGGGAACTGAAGTTGGCAGGTAGATT" +
			"TTTCTCCCTAATGTCTTGGAAATTGCGAGAATACTTTGTAATTACCGAATATTTGATAAAGACTCATTTC" +
			"GTCCCTATGTTTAAAGGCCTGACAATGGCGGACGATCTAACTGCAGTCATTAAAAAGATGTTAGATTCCT" +
			"CATCCGGCCAAGGATTGAAGTCATATGAGGCAATTTGCATAGCCAATCACATTGATTACGAAAAATGGAA" +
			"TAACCACCAAAGGAAGTTATCAAACGGCCCAGTGTTCCGAGTTATGGGCCAGTTCTTAGGTTATCCATCC" +
			"TTAATCGAGAGAACTCATGAATTTTTTGAGAAAAGTCTTATATACTACAATGGAAGACCAGACTTGATGC" +
			"GTGTTCACAACAACACACTGATCAATTCAACCTCCCAACGAGTTTGTTGGCAAGGACAAGAGGGTGGACT" +
			"GGAAGGTCTACGGCAAAAAGGATGGAGTATCCTCAATCTACTGGTTATTCAAAGAGAGGCTAAAATCAGA" +
			"AACACTGCTGTCAAAGTCTTGGCACAAGGTGATAATCAAGTTATTTGCACACAGTATAAAACGAAGAAAT" +
			"CGAGAAACGTTGTAGAATTACAGGGTGCTCTCAATCAAATGGTTTCTAATAATGAGAAAATTATGACTGC" +
			"AATCAAAATAGGGACAGGGAAGTTAGGACTTTTGATAAATGACGATGAGACTATGCAATCTGCAGATTAC" +
			"TTGAATTATGGAAAAATACCGATTTTCCGTGGAGTGATTAGAGGGTTAGAGACCAAGAGATGGTCACGAG" +
			"TGACTTGTGTCACCAATGACCAAATACCCACTTGTGCTAATATAATGAGCTCAGTTTCCACAAATGCTCT" +
			"CACCGTAGCTCATTTTGCTGAGAACCCAATCAATGCCATGATACAGTACAATTATTTTGGGACATTTGCT" +
			"AGACTCTTGTTGATGATGCATGATCCTGCTCTTCGTCAATCATTGTATGAAGTTCAAGATAAGATACCGG" +
			"GCTTGCACAGTTCTACTTTCAAATACGCCATGTTGTATTTGGACCCTTCCATTGGAGGAGTGTCGGGCAT" +
			"GTCTTTGTCCAGGTTTTTGATTAGAGCCTTCCCAGATCCCGTAACAGAAAGTCTCTCATTCTGGAGATTC" +
			"ATCCATGTACATGCTCGAAGTGAGCATCTGAAGGAGATGAGTGCAGTATTTGGAAACCCCGAGATAGCCA" +
			"AGTTTCGAATAACTCACATAGACAAGCTAGTAGAAGATCCAACCTCTCTGAACATCGCTATGGGAATGAG" +
			"TCCAGCGAACTTGTTAAAGACTGAGGTTAAAAAATGCTTAATCGAATCAAGACAAACCATCAGGAACCAG" +
			"GTGATTAAGGATGCAACCATATATTTGTATCATGAAGAGGATCGGCTCAGAAGTTTCTTATGGTCAATAA" +
			"ATCCTCTGTTCCCTAGATTTTTAAGTGAATTCAAATCAGGCACTTTTTTGGGAGTCGCAGACGGGCTCAT" +
			"CAGTCTATTTCAAAATTCTCGTACTATTCGGAACTCCTTTAAGAAAAAGTATCATAGGGAATTGGATGAT" +
			"TTGATTGTGAGGAGTGAGGTATCCTCTTTGACACATTTAGGGAAACTTCATTTGAGAAGGGGATCATGTA" +
			"AAATGTGGACATGTTCAGCTACTCATGCTGACACATTAAGATACAAATCCTGGGGCCGTACAGTTATTGG" +
			"GACAACTGTACCCCATCCATTAGAAATGTTGGGTCCACAACATCGAAAAGAGACTCCTTGTGCACCATGT" +
			"AACACATCAGGGTTCAATTATGTTTCTGTGCATTGTCCAGACGGGATCCATGACGTCTTTAGTTCACGGG" +
			"GACCATTGCCTGCTTATCTAGGGTCTAAAACATCTGAATCTACATCTATTTTGCAGCCTTGGGAAAGGGA" +
			"AAGCAAAGTCCCACTGATTAAAAGAGCTACACGTCTTAGAGATGCTATCTCTTGGTTTGTTGAACCCGAC" +
			"TCTAAACTAGCAATGACTATACTTTCTAACATCCACTCTTTAACAGGCGAAGAATGGACCAAAAGGCAGC" +
			"ATGGGTTCAAAAGAACAGGGTCTGCCCTTCATAGGTTTTCGACATCTCGGATGAGCCATGGTGGGTTCGC" +
			"ATCTCAGAGCACTGCAGCATTGACCAGGTTGATGGCAACTACAGACACCATGAGGGATCTGGGAGATCAG" +
			"AATTTCGACTTTTTATTCCAAGCAACGTTGCTCTATGCTCAAATTACCACCACTGTTGCAAGAGACGGAT" +
			"GGATCACCAGTTGTACAGATCATTATCATATTGCCTGTAAGTCCTGTTTGAGACCCATAGAAGAGATCAC" +
			"CCTGGACTCAAGTATGGACTACACGCCCCCAGATGTATCCCATGTGCTGAAGACATGGAGGAATGGGGAA" +
			"GGTTCGTGGGGACAAGAGATAAAACAGATCTATCCTTTAGAAGGGAATTGGAAGAATTTAGCACCTGCTG" +
			"AGCAATCCTATCAAGTCGGCAGATGTATAGGTTTTCTATATGGAGACTTGGCGTATAGAAAATCTACTCA" +
			"TGCCGAGGACAGTTCTCTATTTCCTCTATCTATACAAGGTCGTATTAGAGGTCGAGGTTTCTTAAAAGGG" +
			"TTGCTAGACGGATTAATGAGAGCAAGTTGCTGCCAAGTAATACACCGGAGAAGTCTGGCTCATTTGAAGA" +
			"GGCCGGCCAACGCAGTGTACGGAGGTTTGATTTACTTGATTGATAAATTGAGTGTATCACCTCCATTCCT" +
			"TTCTCTTACTAGATCAGGACCTATTAGAGACGAATTAGAAACGATTCCCCACAAGATCCCAACCTCCTAT" +
			"CCGACAAGCAACCGTGATATGGGGGTGATTGTCAGAAATTACTTCAAATACCAATGCCGTCTAATTGAAA" +
			"AGGGAAAATACAGATCACATTATTCACAATTATGGTTATTCTCAGATGTCTTATCCATAGACTTCATTGG" +
			"ACCATTCTCTATTTCCACCACCCTCTTGCAAATCCTATACAAGCCATTTTTATCTGGGAAAGATAAGAAT" +
			"GAGTTGAGAGAGCTGGCAAATCTTTCTTCATTGCTAAGATCAGGAGAGGGGTGGGAAGACATACATGTGA" +
			"AATTCTTCACCAAGGACATATTATTGTGTCCAGAGGAAATCAGACATGCTTGCAAGTTCGGGATTGCTAA" +
			"GGATAATAATAAAGACATGAGCTATCCCCCTTGGGGAAGGGAATCCAGAGGGACAATTACAACAATCCCT" +
			"GTTTATTATACGACCACCCCTTACCCAAAGATGCTAGAGATGCCTCCAAGAATCCAAAATCCCCTGCTGT" +
			"CCGGAATCAGGTTGGGCCAATTACCAACTGGCGCTCATTATAAAATTCGGAGTATATTACATGGAATGGG" +
			"AATCCATTACAGGGACTTCTTGAGTTGTGGAGACGGCTCCGGAGGGATGACTGCTGCATTACTACGAGAA" +
			"AATGTGCATAGCAGAGGAATATTCAATAGTCTGTTAGAATTATCAGGGTCAGTCATGCGAGGCGCCTCTC" +
			"CTGAGCCCCCCAGTGCCCTAGAAACTTTAGGAGGAGATAAATCGAGATGTGTAAATGGTGAAACATGTTG" +
			"GGAATATCCATCTGACTTATGTGACCCAAGGACTTGGGACTATTTCCTCCGACTCAAAGCAGGCTTGGGG" +
			"CTTCAAATTGATTTAATTGTAATGGATATGGAAGTTCGGGATTCTTCTACTAGCCTGAAAATTGAGACGA" +
			"ATGTTAGAAATTATGTGCACCGGATTTTGGATGAGCAAGGAGTTTTAATCTACAAGACTTATGGAACATA" +
			"TATTTGTGAGAGCGAAAAGAATGCAGTAACAATCCTTGGTCCCATGTTCAAGACGGTCGACTTAGTTCAA" +
			"ACAGAATTTAGTAGTTCTCAAACGTCTGAAGTATATATGGTATGTAAAGGTTTGAAGAAATTAATCGATG" +
			"AACCCAATCCCGATTGGTCTTCCATCAATGAATCCTGGAAAAACCTGTACGCATTCCAGTCATCAGAACA" +
			"GGAATTTGCCAGAGCAAAGAAGGTTAGTACATACTTTACCTTGACAGGTATTCCCTCCCAATTCATTCCT" +
			"GATCCTTTTGTAAACATTGAGACTATGCTACAAATATTCGGAGTACCCACGGGTGTGTCTCATGCGGCTG" +
			"CCTTAAAATCATCTGATAGACCTGCAGATTTATTGACCATTAGCCTTTTTTATATGGCGATTATATCGTA" +
			"TTATAACATCAATCATATCAGAGTAGGACCGATACCTCCGAACCCCCCATCAGATGGAATTGCACAAAAT" +
			"GTGGGGATCGCTATAACTGGTATAAGCTTTTGGCTGAGTTTGATGGAGAAAGACATTCCACTATATCAAC" +
			"AGTGTTTAGCAGTTATCCAGCAATCATTCCCGATTAGGTGGGAGGCTGTTTCAGTAAAAGGAGGATACAA" +
			"GCAGAAGTGGAGTACTAGAGGTGATGGGCTCCCAAAAGATACCCGAATTTCAGACTCCTTGGCCCCAATC" +
			"GGGAACTGGATCAGATCTCTGGAATTGGTCCGAAACCAAGTTCGTCTAAATCCATTCAATGAGATCTTGT" +
			"TCAATCAGCTATGTCGTACAGTGGATAATCATTTGAAATGGTCAAATTTGCGAAGAAACACAGGAATGAT" +
			"TGAATGGATCAATAGACGAATTTCAAAAGAAGACCGGTCTATACTGATGTTGAAGAGTGACCTACACGAG" +
			"GAAAACTCTTGGAGAGATTAAAAAATCATGAGGAGACTCCAAACTTTAAGTATGAAAAAAACTTTGATCC" +
			"TTAAGACCCTCTTGTGGTTTTTATTTTTTATCTGGTTTTGTGGTCTTCGT";
}

