#---------------------- Third script: for showing the effect of reducing per genome mutation rate on the basic multiplicative model --------------------------
rm(list=ls())		# Delete all existing variables 

s = 0.1 # selection coefficient
fitness = NULL
k.values = NULL
prog_fit = NULL # fitness of progeny with increasing numbers of mutations
total_prog_fit = NULL #  fitness of progeny = sum of frequency of each mutant class of progeny multiplied by its fitness
prop = NULL
slope = NULL
mut_rate = NULL
start_m = 0.0001 # starting mutation rate per bp
g = 10000 # genome size (no overlap)

class_fitness <- function(n, p) { # function for determining total number of mutations: those that fall in regions of gene overlap count twice!
	prob_over = (p/2)/((1-p)+(p/2)) # probability of mutation falling in region of overlap
	for (k in 0:n) { # go through all possible combinations of 0 -> n mutations falling in regions of overlap
		bin_coeff = factorial(n) / (factorial(k) * factorial(n - k)) # binomial coefficient = number of combinations in which can achieve this number of muattions in overlap
		exp_freq = prob_over^k * (1-prob_over)^(n-k) * bin_coeff # relative expected freqencies
		fitness[k+1] = exp_freq * exp( - s * ( (k*2) + (n-k) ) )
	}
	return(sum(fitness))
}

for(j in 1:100) {
	m = start_m/j # reducing mutation rate
	for(i in 0:100) {
		p = i/100 # just converting p from an integer to a proportion
		u = m * g * (1 - p/2)  # adjust per genome mutation rate due to overlap
		freq = exp(-u) # need frequency of zero class at start
		prog_fit[1] = freq * 1 # = frequency of progeny with zero mutations multiplied by their fitness, which equals one (= exp(- s * 0 ))
		for(n in 1:5) { # no need to go beyond frequency of progeny with 5 mutations (proportion is < 0.001)
			freq = freq * (u/n)
			prog_fit[n+1] = freq * class_fitness(n, p) # multiply frequency of each class by its fitness
		}
		total_prog_fit[i+1] = sum(prog_fit)
		prop[i+1] = p 
	}
	saved.lm = lm(total_prog_fit ~ prop)
	slope[j] = saved.lm$coefficients[2]
	mut_rate[j] = m
}
	

plot(mut_rate, slope, col=1,  type="l", xlab="mut rate", ylab="slope", main="", frame.plot = FALSE)
