#---------------------- First script: for showing the efect of gene overlap on a multiplicative model of fitness --------------------------
rm(list=ls())		# Delete all existing variables 

m = 0.0001 # mutation rate per bp
g = 10000 # starting genome size (no overlap)
s = 0.1 # selection coefficient

fitness = NULL
prog_fit = NULL # fitness of progeny with increasing numbers of mutations
total_prog_fit = NULL #  fitness of progeny = sum of frequency of each mutant class of progeny multiplied by its fitness
prop = NULL

class_fitness <- function(n, p) { # function for determining total number of mutations: those that fall in regions of gene overlap count twice!
	prob_over = (p/2)/((1-p)+(p/2)) # probability of mutation falling in region of overlap
	for (k in 0:n) { # go through all possible combinations of 0 -> n mutations falling in regions of overlap
		#exp_freq = (exp(-prob_over)*(prob_over^k))/factorial(k)
		exp_freq = prob_over^k * (1-prob_over)^(n-k) * (factorial(n) / (factorial(k) * factorial(n - k))) # relative expected freqencies. factorial(n) / (factorial(k) * factorial(n - k)) is the binomial coefficient = number of combinations in which can achieve this number of muattions in overlap
		fitness[k+1] = exp_freq * exp( - s * ( (k*2) + (n-k) ) )
	}
	return(sum(fitness))
}

for(i in 0:100) {
	p = i/100 # just converting p from an integer to a proportion
	u = m * g * (1 - p/2) # adjust per genome mutation rate to allow for compression due to overlap
	freq = exp(-u) # need frequency of zero class at start
	prog_fit[1] = freq * 1 # = frequency of progeny with zero mutations multiplied by their fitness, which equals one (= exp(- s * 0 ))
	for(n in 1:10) { # no need to go beyond frequency of progeny with 5 mutations (proportion is < 0.001)
		freq = freq * (u/n)
		prog_fit[n+1] = freq * class_fitness(n, p) # multiply frequency of each class by its fitness
		
	}
	total_prog_fit[i+1] = sum(prog_fit)
	prop[i+1] = p # just for plotting
}

plot(prop, total_prog_fit, col=1, type="l",xlab="overlap", ylab="fitness", main="", frame.plot = FALSE)
