#---------------------- Second script: for comparing different models for the impact of multiple mutations on fitness --------------------------
rm(list=ls())		# Delete all existing variables 

m = 0.0001 # mutation rate per bp
g = 10000 # starting genome size (no overlap)
s = 0.1 # selection coefficient
b = 0.01  # second selection coefficient for epistasis
fitness = NULL
prog_fit_mult = NULL # fitness of progeny with increasing numbers of mutations
total_prog_fit_mult = NULL #  fitness of progeny = sum of frequency of each mutant class of progeny multiplied by its fitness
prog_fit_mult2 = NULL # as above, but for alternative model of multiplicative fitness interactions
total_prog_fit_mult2 = NULL #  # as above, but for alternative model of multiplicative fitness interactions
prog_fit_ant_epi = NULL # as above, but for antagonostic epistasis
total_prog_fit_ant_epi = NULL # as above, but for antagonostic epistasis
prog_fit_syn_epi = NULL # as above, but for synergistic epistasis
total_prog_fit_syn_epi = NULL # as above, but for synergistic epistasis
prog_fit_add = NULL # as above, but for additive fitness
total_prog_fit_add = NULL # as above, but for additive fitness
prop = NULL

# basic multiplicative fitness
class_fitness_mult <- function(n, p) { # function for determining total number of mutations: those that fall in regions of gene overlap count twice!
	prob_over = (p/2)/((1-p)+(p/2)) # probability of mutation falling in region of overlap

	for (k in 0:n) { # go through all possible combinations of 0 -> n mutations falling in regions of overlap
		bin_coeff = factorial(n) / (factorial(k) * factorial(n - k)) # binomial coefficient = number of combinations in which can achieve this number of muattions in overlap
		exp_freq = prob_over^k * (1-prob_over)^(n-k) * bin_coeff # relative expected freqencies
		fitness[k+1] = exp_freq * exp( - s * ( (k*2) + (n-k) ) )
	}
	return(sum(fitness))
}

# alternative multiplicative fitness
class_fitness_mult2 <- function(n, p) { # function for determining total number of mutations: those that fall in regions of gene overlap count twice!
	prob_over = (p/2)/((1-p)+(p/2)) # probability of mutation falling in region of overlap

	for (k in 0:n) { # go through all possible combinations of 0 -> n mutations falling in regions of overlap
		bin_coeff = factorial(n) / (factorial(k) * factorial(n - k)) # binomial coefficient = number of combinations in which can achieve this number of muattions in overlap
		exp_freq = prob_over^k * (1-prob_over)^(n-k) * bin_coeff # relative expected freqencies
		fitness[k+1] = exp_freq * (1 - s)^((k*2) + (n-k))
	}
	return(sum(fitness))
}

# antagonistic epistasis
class_fitness_ant_epi <- function(n, p) {
	b = 0.01  # second selection coefficient for epistasis
	prob_over = (p/2)/((1-p)+(p/2))
	for (k in 0:n) { # go through all possible combinations of 0 -> n mutations falling in regions of overlap
		bin_coeff = factorial(n) / (factorial(k) * factorial(n - k)) # binomial coefficient = number of combinations in which can achieve this number of muattions in overlap
		exp_freq = prob_over^k * (1-prob_over)^(n-k) * bin_coeff # relative expected freqencies
		fitness[k+1] = exp_freq *  exp(- s * ((k*2) + (n-k))  + b * ((k*2) + (n-k))^2)
	}
	return(sum(fitness))
}

# synergistic epistasis
class_fitness_syn_epi <- function(n, p) {
	b = 0.02  # second selection coefficient for epistasis
	prob_over = (p/2)/((1-p)+(p/2))
	for (k in 0:n) { # go through all possible combinations of 0 -> n mutations falling in regions of overlap
		bin_coeff = factorial(n) / (factorial(k) * factorial(n - k)) # binomial coefficient = number of combinations in which can achieve this number of muattions in overlap
		exp_freq = prob_over^k * (1-prob_over)^(n-k) * bin_coeff # relative expected freqencies
		fitness[k+1] = exp_freq *   exp(- s * ((k*2) + (n-k))  - b * ((k*2) + (n-k))^2)
	}
	return(sum(fitness))
}

# additive epistasis
class_fitness_add <- function(n, p) {
	prob_over = (p/2)/((1-p)+(p/2))
	for (k in 0:n) { # go through all possible combinations of 0 -> n mutations falling in regions of overlap
		bin_coeff = factorial(n) / (factorial(k) * factorial(n - k)) # binomial coefficient = number of combinations in which can achieve this number of muattions in overlap
		exp_freq = prob_over^k * (1-prob_over)^(n-k) * bin_coeff # relative expected freqencies
		fitness[k+1] = exp_freq *   (1 - (s * ((k*2) + (n-k))))
	}
	return(sum(fitness))
}



for(i in 0:100) {
	p = i/100 # just converting p from an integer to a proportion
	u = m * g * (1 - p/2) # adjust per genome mutation rate due to overlap
	freq = exp(-u) # need frequency of zero class at start
	prog_fit_mult[1] = freq * 1 # = frequency of progeny with zero mutations multiplied by their fitness, which equals one (= exp(- s * 0 ))
	prog_fit_mult2[1] = freq * 1
	prog_fit_ant_epi[1] = freq * 1 # same for all fitness functions
	prog_fit_syn_epi[1] = freq * 1
	prog_fit_add[1] = freq * 1
	for(n in 1:10) { # no need to go beyond frequency of progeny with 5 mutations (proportion is < 0.001)
		freq = freq * (u/n)
		prog_fit_mult[n+1] = freq * class_fitness_mult(n, p) # multiply frequency of each class by its fitness
		prog_fit_mult2[n+1] = freq * class_fitness_mult2(n, p) # multiply frequency of each class by its fitness
		prog_fit_ant_epi[n+1] = freq * class_fitness_ant_epi(n, p) # multiply frequency of each class by its fitness
		prog_fit_syn_epi[n+1] = freq * class_fitness_syn_epi(n, p) # multiply frequency of each class by its fitness
		prog_fit_add[n+1] = freq * class_fitness_add(n, p) # multiply frequency of each class by its fitness

		
	}
	total_prog_fit_mult[i+1] = sum(prog_fit_mult)
	total_prog_fit_mult2[i+1] = sum(prog_fit_mult2)
	total_prog_fit_ant_epi[i+1] = sum(prog_fit_ant_epi)
	total_prog_fit_syn_epi[i+1] = sum(prog_fit_syn_epi)
	total_prog_fit_add[i+1] = sum(prog_fit_add)
	prop[i+1] = p # just for plotting

}

plot(prop, total_prog_fit_mult/total_prog_fit_mult[1], col=1, type="l", ylim = range(0.98, 1.02), xlab="Prop overlap", ylab="Fitness", main="", frame.plot = FALSE)
points(prop, total_prog_fit_mult2/total_prog_fit_mult2[1], col=2, type="l")
points(prop, total_prog_fit_ant_epi/total_prog_fit_ant_epi[1], col=3, type="l")
points(prop, total_prog_fit_syn_epi/total_prog_fit_syn_epi[1], col=4, type="l")
points(prop, total_prog_fit_add/total_prog_fit_add[1], col=5, type="l")
legend(x="topright", legend=c("mult", "mult2", "ant_epi", "syn_epi", "add"), fill= 1:5, bty="n")
