int_len_all<-scan("int_len_all")
int_len_all_break = seq(from=0, to=max(int_len_all)+50, by=50)
term_len_all<-scan("term_len_all")
term_len_all_break = seq(from=0, to=max(term_len_all)+50, by=50)

# get simulated lengths
int_sim1<-scan("int_sim1")
int_sim2<-scan("int_sim2")
term_sim1<-scan("term_sim1")
term_sim2<-scan("term_sim2")
term_sim_up1<-scan("term_sim_up1")
term_sim_up2<-scan("term_sim_up2")

# convert amino acid length to nucleotide length
int_sim1_nuc<-int_sim1*3
int_sim2_nuc<-int_sim2*3
term_sim1_nuc<-term_sim1*3
term_sim2_nuc<-term_sim2*3

# remove zero values
int_sim1_nuc<-int_sim1_nuc[int_sim1_nuc  > 0]
int_sim2_nuc<-int_sim2_nuc[int_sim2_nuc  > 0]


# set breaks
int_sim1_nuc_break = seq(from=0, to=max(int_sim1_nuc)+10, by=6)
int_sim2_nuc_break = seq(from=0, to=max(int_sim2_nuc)+10, by=6)
term_sim1_nuc_break = seq(from=0, to=max(term_sim1_nuc)+10, by=6)
term_sim2_nuc_break = seq(from=0, to=max(term_sim2_nuc)+10, by=6)
int_len_all_break = seq(from=0, to=max(int_len_all)+50, by=50)
term_len_all_break = seq(from=0, to=max(term_len_all)+50, by=50)

par(mfrow=c(2,1))

# Note, a bug in r means that the Y axis values are incorrect
hist(freq=FALSE,int_len_all, breaks=int_len_all_break,  xlim = range(0, max(term_len_all)+500), ylim=range(0,0.015), col = "grey", xlab = "Overlap (bp)", ylab = "Probability", main="")
temp = hist(plot = FALSE, freq=FALSE, int_sim1_nuc, breaks=int_sim1_nuc_break)
lines(temp$mids, temp$density,lwd = 2)
temp = hist(plot = FALSE, freq=FALSE, int_sim2_nuc, breaks=int_sim2_nuc_break)
lines(temp$mids, temp$density, lwd = 0.5)
title(main = list("A", font=96))

hist(freq=FALSE,term_len_all, breaks=term_len_all_break, xlim = range(0, max(term_len_all)+500), ylim=range(0,0.025), col = "grey", xlab = "Overlap (bp)", ylab = "Probability", main = "")
temp = hist(plot = FALSE, freq=FALSE, term_sim1_nuc, breaks=term_sim1_nuc_break)
lines(temp$mids, temp$density,lwd = 2)
temp = hist(plot = FALSE, freq=FALSE, term_sim2_nuc, breaks=term_sim2_nuc_break)
lines(temp$mids, temp$density,lwd = 0.5)
title(main = list("B", font=96))

