## snp reports
## functions to report for all available data in a SnpSetIllumina object
reportSamplesSmoothCopyNumber<-function(snpdata, grouping, normalizedTo=2, smooth.lambda=2, ridge.kappa=0, plotLOH=c("none","marker","line","NorTum"), ...){
  # default grouping is by 4 in sequence of samples in snpdata
  plotLOH<-match.arg(plotLOH)
  if (missing(grouping)) grouping<-floor(seq(along.with=sampleNames(snpdata),by=0.25))
  # make sure chromosmes are sorted
  ind<-order(pData(featureData(snpdata))[,"CHR"],pData(featureData(snpdata))[,"MapInfo"])
  snpdata<-snpdata[ind,]
  sample.colors<-c("red","green","blue","orange","brown","turquoise","yellow","purple","pink","magenta")
  chroms<-unique(pData(featureData(snpdata))[,"CHR"])
  intensities<-assayData(snpdata)[["intensity"]]
  for (pageID in levels(factor(grouping))){
    samples<-sampleNames(snpdata)[grouping == pageID]
    if (length(samples)>0) {
      dchrompos<-prepareGenomePlot(pData(featureData(snpdata))[,c("CHR","MapInfo")],...)
      for (i1 in 1:length(samples) ) {
        for (chrom in chroms) {
          probes<-pData(featureData(snpdata))[,"CHR"] == chrom
          if (sum(!is.na(intensities[probes,samples[i1]]))>10 ) {
            smoothed<-quantsmooth(intensities[probes,samples[i1]],smooth.lambda=smooth.lambda,ridge.kappa=ridge.kappa)
            lines(dchrompos[probes,2],dchrompos[probes,1]+(smoothed-normalizedTo)/normalizedTo,col=sample.colors[i1],lwd=1.5)
            if (plotLOH!="none") {
              probeNames<-featureNames(snpdata)[probes]
              if (plotLOH=="marker") {
                chromhet<-heterozygosity(assayData(snpdata)[["call"]][probes,samples[i1]])
                LOH<-probeNames[chromhet>20]
                if (length(LOH)>0) points(dchrompos[LOH,2],dchrompos[LOH,1]-0.3-(i1*0.05),pch="-",col=sample.colors[i1])
              }
              if (plotLOH=="line") {
                chromhet<-heterozygosity(assayData(snpdata)[["call"]][probes,samples[i1]])
                lines(dchrompos[probes,2],dchrompos[probes,1]+scaleto(chromhet,c(10,40),c(0.1,-0.4)),col=sample.colors[i1],lty=2)
              }
              if (plotLOH=="NorTum" && pData(snpdata)[samples[i1],"NorTum"]!="N") {
                ## check availability of normal to compare with
                n1<-grep("N",as.character(pData(snpdata)[samples,"NorTum"]))
                if (length(n1)>0) {
                  compGenotype<-compareGenotypes(assayData(snpdata)[["call"]][probes,samples[i1]],assayData(snpdata)[["call"]][probes,samples[n1[1]]])
                  LOH<-probeNames[compGenotype=="l"] # loss 
                  if(length(LOH)>0) points(dchrompos[LOH,2],dchrompos[LOH,1]-0.3-(i1*0.05),pch="|",col=sample.colors[i1])
                  LOH<-probeNames[compGenotype=="i"] # heterozygous normal
                  if(length(LOH)>0) points(dchrompos[LOH,2],dchrompos[LOH,1]-0.3-(i1*0.05),pch="'",col=sample.colors[i1])
                }
              }
            }
          }
        }
      }
      legend("topleft",samples,col=c(sample.colors[1:length(samples)]),pch=18,ncol=3)
    }
  }
}
pdfSamplesSmoothCopyNumber<-function(object,filename,...) {
  pdf(filename,paper="a4",width=7.2,height=11)
	reportSamplesSmoothCopyNumber(object,...)
	dev.off() 
}

reportChromosomesSmoothCopyNumber<-function(snpdata, grouping, normalizedTo=2, smooth.lambda=2, ridge.kappa=0, plotLOH=c("none","marker","line","NorTum"), ...){
  ideo.width<-0.15
  ideo.ypos<-normalizedTo+(ideo.width/2)
  ideo.bleach<-0.25
  plotLOH<-match.arg(plotLOH)
  if (missing(grouping)) grouping<-floor(seq(along.with=sampleNames(snpdata),by=0.25))
  sample.colors<-c("red","green","blue","orange","brown","turquoise","yellow","purple","pink","magenta")
  # make sure chromosmes are sorted
  ind<-order(numericCHR(pData(featureData(snpdata))[,"CHR"]),pData(featureData(snpdata))[,"MapInfo"])
  snpdata<-snpdata[ind,]
  chroms<-unique(numericCHR(pData(featureData(snpdata))[,"CHR"]))
  intensities<-assayData(snpdata)[["intensity"]]
  for (group in levels(factor(grouping))){
    samples<-sampleNames(snpdata)[grouping == group]
    if (length(samples)>0) {
      for (chrom in chroms) {
        probes<-numericCHR(pData(featureData(snpdata))[,"CHR"]) == chrom
        if (any(apply(intensities[probes,samples,drop=FALSE],2,function(x) sum(!is.na(x))>10))) {
          plot(c(0,max(lengthChromosome(chrom,"bases"),pData(featureData(snpdata))[probes,"MapInfo"])),c(1,3),main=paste(group,"Chromosome",characterCHR(chrom)),type="n",ylab="intensity",xlab="",xaxt="n")
          paintCytobands(chrom,pos=c(0,ideo.ypos),units="bases",width=ideo.width,legend=FALSE,bleach=ideo.bleach)
          plotSmoothed(intensities[probes,samples,drop=FALSE],pData(featureData(snpdata))[probes,"MapInfo"],smooth.lambda=smooth.lambda,plotnew=FALSE,cols=sample.colors,...)
          legend("topleft",samples,col=1:length(samples)+1,lty=1,lwd=2,ncol=length(samples))
          if (plotLOH!="none") {
            probeNames<-featureNames(snpdata)[probes]
            markerbase<-par("yaxp")[1]
            markerinterval<-(normalizedTo-markerbase)/20
            if (plotLOH=="marker") {
              for (samp in 1:length(samples)) {
                chromhet<-heterozygosity(assayData(snpdata)[["call"]][probes,samples[samp]])
                LOH<-probeNames[chromhet>20]
                if (length(LOH)>0) points(pData(featureData(snpdata))[LOH,"MapInfo"],markerbase+(samp*markerinterval),pch="-",col=sample.colors[samp])
              }
            }
            if (plotLOH=="line") {
              for (samp in 1:length(samples)) {
                chromhet<-heterozygosity(assayData(snpdata)[["call"]][probes,samples[samp]])
                lines(pData(featureData(snpdata))[probes,"MapInfo"],scaleto(chromhet,c(10,40),c(normalizedTo,markerbase)),col=sample.colors[samp],lty=2)
              }
            }
            if (plotLOH=="NorTum") {
              ## check availability of normal to compare with
              n1<-grep("N",as.character(pData(snpdata)[samples,"NorTum"]))
              t1<-samples[-n1]
              if (length(n1)>0 & length(t1)>0) { # at least 1 normal and 1 tumor sample in group
                for (tum in 1:length(t1)) {
                  compGenotype<-compareGenotypes(assayData(snpdata)[["call"]][probes,t1[tum]],assayData(snpdata)[["call"]][probes,samples[n1[1]]])
                  LOH<-probeNames[compGenotype=="l"] # loss
                  if(length(LOH)>0) points(pData(featureData(snpdata))[LOH,"MapInfo"],rep(markerbase+(tum*markerinterval),length(LOH)),pch="|",col=sample.colors[match(t1[tum],samples)])
                  LOH<-probeNames[compGenotype=="i"] # heterozygous normal)
                  if(length(LOH)>0) points(pData(featureData(snpdata))[LOH,"MapInfo"],rep(markerbase+(tum*markerinterval),length(LOH)),pch="'",col=sample.colors[match(t1[tum],samples)])
                }
              }
            }
          }
        }
      }
    }
  }
}

pdfChromosomesSmoothCopyNumber<-function(object,filename,...) {
  pdf(filename,paper="a4",width=7.2,height=11)
  par(mfrow=c(4,1),mar=c(1.5,2,2,0))
	reportChromosomesSmoothCopyNumber(object,...)
	dev.off() 
}

getMidMaxIdx<-function(groups){
  groups<-as.character(groups)
  lvls<-levels(factor(groups))
  midpos<-NULL
  maxpos<-NULL
  for(lvl in 1:length(lvls)) {
    midpos[lvl]<-mean(grep(paste("^",lvls[lvl],"$",sep=""),groups))-0.5
    maxpos[lvl]<-max(grep(paste("^",lvls[lvl],"$",sep=""),groups))
  }
  data.frame(midpos,maxpos,row.names=lvls)
}

reportGenomeGainLossLOH<-function(object,grouping,plotSampleNames=FALSE,distance.min,
  upcolor="red",downcolor="blue",lohcolor="grey",lohwidth=1,segment=101,...) {
  ind<-order(numericCHR(reporterInfo(object)$CHR),reporterInfo(object)$MapInfo)
  object<-object[ind,]
  if (missing(distance.min)) distance.min=1e+9
  
  # determine gained and lost probes
  plot(0,xlim=c(0,ncol(object)),ylim=c(nrow(object),0),type="n",xaxt="n",yaxt="n",xlab="",ylab="chromosome")
  par(usr=c(0,ncol(object),nrow(object),0))
  for (smp in 1:ncol(object)) {
    regions<-getChangedRegions(assayData(object)$intensity[,smp],segment=segment,...)
    if (!is.null(regions)) rect(smp-1,regions[,"start"]-1,smp-0.5,regions[,"end"],col=ifelse(regions[,"up"],upcolor,downcolor),border=NA)
    loh<-which(assayData(object)$loh[,smp])
    if (length(loh)>0){
      position<-pData(featureData(object))$MapInfo[loh]
      distance<-abs(c(position,0)-c(0,position))
      min.distance<-apply(cbind(distance[-1],distance[-length(distance)]),1,min)
      loh<-loh[min.distance<distance.min]
      if (length(loh)>0) rect(smp-0.5,loh-1-lohwidth,smp,loh+lohwidth,col=lohcolor,border=NA)
    }
    #
    #pLOH<-ifelse(assayData(object)$call[,smp]=="H",(1-assayData(object)$GRS[,smp]),1)
    #het.nrm<-which(assayData(object)$nor.gt[,smp]=="H") # & assayData(object)$nor.qs[,smp]>0.9
    #points(smp-0.5*pLOH[het.nrm],het.nrm,pch=".")
    #points(smp-0.5*assayData(object)$nor.qs[het.nrm,smp],het.nrm,pch=".",col="cyan")

  }
  abline(v=1:(ncol(object)-1),col="grey")
  if (!missing(grouping)) {
    xax<-getMidMaxIdx(grouping)
    axis(3,xax$midpos,row.names(xax))
    abline(v=xax$maxpos)
  }
  if (plotSampleNames) {
    axis(1,(1:ncol(object))-0.5,sampleNames(object),las=2,cex.axis=0.6)
  }
  yax<-getMidMaxIdx(reporterInfo(object)$CHR)
  axis(2,yax$midpos,row.names(yax))
  abline(h=yax$maxpos)
}

reportChromosomeGainLossLOH<-function(object,grouping,plotSampleNames=FALSE,distance.min,
  upcolor="red",downcolor="blue",lohcolor="grey",segment=101,proportion=0.2,plotLOH=TRUE,...) {
  ind<-order(numericCHR(reporterInfo(object)$CHR),reporterInfo(object)$MapInfo)
  if (missing(distance.min)) distance.min=1e+9
  object<-object[ind,]
  xmin<-ncol(object)-ncol(object)/(1-proportion)
  cb.x<-xmin*0.6
  cb.w<- -xmin*0.2
  if (plotLOH) cn.w<-0.5 else cn.w<-1
  for (chrom in 1:22) {
    probes<-reporterInfo(object)$CHR == chrom
    lengthchrom<-max(reporterInfo(object)$MapInfo[probes],na.rm=TRUE)
    plot(0,xlim=c(xmin,ncol(object)),ylim=c(0,lengthchrom),xlab="",ylab="",xaxt="n",yaxt="n",main=paste("chromosome",chrom),type="n")
    myusr<-par()$usr
    myusr[1]<-xmin
    myusr[2]<-ncol(object)
    par(usr=myusr)
    paintCytobands(chrom,c(cb.x,lengthchrom),units="bases",width=cb.w,orientation="v",legend=TRUE)
    for (smp in 1:ncol(object)) {
      updown<-getChangedRegions(assayData(object)$intensity[probes,smp],reporterInfo(object)$MapInfo[probes],
                                segment=segment,normalized.to=2,interval=0.8,smooth.lambda=5469/1500)
      if (!is.null(updown)) {
        rect(smp-1,lengthchrom-updown[,"start"],smp-1+cn.w,lengthchrom-updown[,"end"],col=ifelse(updown[,"up"],upcolor,downcolor),border=NA)
      }
      if (plotLOH) {
        probe.w<-lengthchrom/sum(probes)/2
        loh<-featureNames(object)[assayData(object)$loh[,smp] & probes]
        if (length(loh)>0) {
          position<-pData(featureData(object))[loh,"MapInfo"]
          distance<-abs(c(position,0)-c(0,position))
          min.distance<-apply(cbind(distance[-1],distance[-length(distance)]),1,min)
          loh<-loh[min.distance<distance.min]
          if (length(loh)>0) rect(smp-0.5,lengthchrom-reporterInfo(object)[loh,"MapInfo"]-probe.w,smp,lengthchrom-reporterInfo(object)[loh,"MapInfo"]+probe.w,col=lohcolor,border=NA)
        }
      }
    }
    if (plotSampleNames) {
      axis(1,(1:ncol(object))-0.5,sampleNames(object),las=2,cex.axis=0.6)
    }
    abline(v=0:(ncol(object)-1),col="grey")
    if (!missing(grouping)) {
      xax<-getMidMaxIdx(grouping)
      axis(3,xax$midpos,row.names(xax))
      abline(v=xax$maxpos)
    }
  }
}

pdfChromosomeGainLossLOH<-function(pdffile,object,mfrow=par()$mfrow,mar=par()$mar,...) {
  pdf(pdffile,width=8,height=11)
  par(mfrow=mfrow,mar=mar)
  reportChromosomeGainLossLOH(object,...)
  dev.off()
}



plotGroupZygosity <- function(Green,Red,GenCall,Grouping,NorTum,NormalizedTo=1,...) {
  # Plot alleles. Green to X-axis, Red to Y-axis
  # GenCall: A,AA = -
  #          H,AB = +
  #          B,BB = |
  #          Not-recognized = .
  # Grouping : colors
  # NorTum : Size
  # NormalizedTo : <=0 Fitted to largest spread in Green/Red; >0 used to set limits (min(Red,Green), 2*Normalized)
  # ... : Transferred to plot()
  chars<-c("-","+","|",".")
  sample.colors<-rep(c("red","green","blue","yellow","orange","brown","purple","turquoise","pink","magenta"),length.out=length(Green))
  if (NormalizedTo<=0) plotsize<-c(min(Green,Red,na.rm=TRUE),max(Green,Red,na.rm=TRUE))
  else plotsize<-c(min(Green,Red,na.rm=TRUE),2*NormalizedTo)
  plot(plotsize,plotsize,type="n",cex.axis=0.6,...)
  char<-chars[(GenCall=="A" | GenCall=="AA") * 1 + (GenCall=="H" | GenCall=="AB")*2 + (GenCall=="B" | GenCall=="BB") * 3]
  char[char==0]<-4
  # now draw in colors for sampleids, shapes for snpcall, size for tum/norm (tum is smaller)
  charsize<-1.5 + ((NorTum=="N")*0.5)
  charcolor<-sample.colors[as.numeric(factor(Grouping))]
  for (chip in 1:length(char)) {
    points(Red[chip],Green[chip],col=charcolor[chip],pch=char[chip],cex=charsize[chip])
  }

}

reportGroupZygosity<-function (snpdata,snps,Grouping,NorTum,NormalizedTo=1){
  pdf("GroupZygosity.pdf",width=8,height=11)
  par(mfrow=c(4,3),mar=c(2,1,2,1))
  for (snp in snps) plotGroupZygosity(snpdata$Green[snp,],snpdata$Red[snp,],snpdata$GenCall[snp,],Grouping,NorTum,NormalizedTo,main=snp)  
  dev.off()
}

