# Comparison of methodologies
##
##
##
## Set the working directory to the root of Analysis, ProcessedData and Rawdata
##
##
##
setwd("/cn_data")
library(beadarraySNP)
load("Analysis/1280260raw.RData")
### Some default settings
standardNormalization<-function(snpdata) {
  normalizeLoci.SNP(normalizeWithinArrays.SNP(normalizeBetweenAlleles.SNP(snpdata),
       callscore=0.8,relative=TRUE,fixed=FALSE,quantilepersample=TRUE),normalizeTo=2)
}
################################################################################
#  some functions
my.mean<-function(x) { x<-x[!is.na(x)]; if(length(x)>10) mean(x) else NA}
my.sd<-function(x) { x<-x[!is.na(x)]; if(length(x)>10) sd(x) else NA}
################################################################################
# default levels for lambda. Dependent on total number of autosomal probes
lambda.divisor<-1500
il.smooth.lambda<-5469/lambda.divisor
dc.smooth.lambda<-9800/lambda.divisor
bac.smooth.lambda<-3307/lambda.divisor
#
probes<-numericCHR(reporterInfo(all.260)[,"CHR"])<90
rawdata<-all.260[probes,]
data.nrmp<-standardNormalization(rawdata)
il.data<-assayData(data.nrmp)[["intensity"]][,c("44TV","106TV","108TV","514TV")]
il.data.p<-assayData(data.nrmp)[["intensity"]][,c("44TP","106TP","108TP","514TP")]
il.chrompos<- cbind(CHR=numericCHR(reporterInfo(data.nrmp)[,"CHR"]),MapInfo=reporterInfo(data.nrmp)["MapInfo"])
rownames(il.chrompos)<-rownames(il.data)
##  Load dCHIP data (affymetrix)
load("Analysis/dchipCN.RData")
## BAC array data
load("Analysis/bacdata.RData")
probes<-chrompos.bac[,1]<23
cn.bac.par<-cn.bac[probes,c("44TP","106TP","108TV","514TP")]
cn.bac.par[,"108TV"]<-NA
cn.bac<-cn.bac[probes,c("44TV","106TV","108TV","514TV")]
chrompos.bac<-chrompos.bac[probes,]
##
#
# Table 1
# Basic properties of methodologies
categories<-read.table("Analysis/ChangedChromosomes.txt",sep="\t",header=TRUE,row.names=1,as.is=TRUE)
# some strange high values in dchip data, remove these outliers
dc.data[dc.data>10]<-NA
dc.sd<-aggregate(dc.data,by=list(dc.chrompos[,1]),my.sd)[,-1]
dc.mean<-aggregate(dc.data,by=list(dc.chrompos[,1]),my.mean)[,-1]
# illumina data
il.sd<-aggregate(il.data,by=list(il.chrompos[,1]),my.sd)[,-1]
il.mean<-aggregate(il.data,by=list(il.chrompos[,1]),my.mean)[,-1]
# illumina paraffin data
il.p.sd<-aggregate(il.data.p,by=list(il.chrompos[,1]),my.sd)[,-1]
il.p.mean<-aggregate(il.data.p,by=list(il.chrompos[,1]),my.mean)[,-1]
# BAC data
bac.sd<-aggregate(cn.bac,by=list(chrompos.bac[,1]),my.sd)[,-1]
bac.mean<-aggregate(cn.bac,by=list(chrompos.bac[,1]),my.mean)[,-1]
bac.p.sd<-aggregate(cn.bac.par,by=list(chrompos.bac[,1]),my.sd)[,-1]
bac.p.mean<-aggregate(cn.bac.par,by=list(chrompos.bac[,1]),my.mean)[,-1]

options(digits=3)
means.sds<-                c(  mean(dc.mean[categories=="n"]),  mean(dc.sd[categories=="n"]),  mean(il.mean[categories=="n"]),  mean(il.sd[categories=="n"]),  mean(il.p.mean[categories=="n"],na.rm=TRUE),  mean(il.p.sd[categories=="n"],na.rm=TRUE),  mean(bac.mean[categories=="n"]),  mean(bac.sd[categories=="n"]),  mean(bac.p.mean[categories=="n"],na.rm=TRUE),  mean(bac.p.sd[categories=="n"],na.rm=TRUE)  )
means.sds<-rbind(means.sds,c(  mean(dc.mean[categories=="a"]),  mean(dc.sd[categories=="a"]),  mean(il.mean[categories=="a"]),  mean(il.sd[categories=="a"]),  mean(il.p.mean[categories=="a"],na.rm=TRUE),  mean(il.p.sd[categories=="a"],na.rm=TRUE),  mean(bac.mean[categories=="a"]),  mean(bac.sd[categories=="a"]),  mean(bac.p.mean[categories=="a"],na.rm=TRUE),  mean(bac.p.sd[categories=="a"],na.rm=TRUE)  ))
means.sds<-rbind(means.sds,c(  mean(dc.mean[categories=="d"]),  mean(dc.sd[categories=="d"]),  mean(il.mean[categories=="d"]),  mean(il.sd[categories=="d"]),  mean(il.p.mean[categories=="d"],na.rm=TRUE),  mean(il.p.sd[categories=="d"],na.rm=TRUE),  mean(bac.mean[categories=="d"]),  mean(bac.sd[categories=="d"]),  mean(bac.p.mean[categories=="d"],na.rm=TRUE),  mean(bac.p.sd[categories=="d"],na.rm=TRUE)  ))
means.sds<-rbind(means.sds,c(median(dc.mean[categories=="n"]),median(dc.sd[categories=="n"]),median(il.mean[categories=="n"]),median(il.sd[categories=="n"]),median(il.p.mean[categories=="n"],na.rm=TRUE),median(il.p.sd[categories=="n"],na.rm=TRUE),median(bac.mean[categories=="n"]),median(bac.sd[categories=="n"]),median(bac.p.mean[categories=="n"],na.rm=TRUE),median(bac.p.sd[categories=="n"],na.rm=TRUE)  ))
means.sds<-rbind(means.sds,c(median(dc.mean[categories=="a"]),median(dc.sd[categories=="a"]),median(il.mean[categories=="a"]),median(il.sd[categories=="a"]),median(il.p.mean[categories=="a"],na.rm=TRUE),median(il.p.sd[categories=="a"],na.rm=TRUE),median(bac.mean[categories=="a"]),median(bac.sd[categories=="a"]),median(bac.p.mean[categories=="a"],na.rm=TRUE),median(bac.p.sd[categories=="a"],na.rm=TRUE)  ))
means.sds<-rbind(means.sds,c(median(dc.mean[categories=="d"]),median(dc.sd[categories=="d"]),median(il.mean[categories=="d"]),median(il.sd[categories=="d"]),median(il.p.mean[categories=="d"],na.rm=TRUE),median(il.p.sd[categories=="d"],na.rm=TRUE),median(bac.mean[categories=="d"]),median(bac.sd[categories=="d"]),median(bac.p.mean[categories=="d"],na.rm=TRUE),median(bac.p.sd[categories=="d"],na.rm=TRUE)  ))
rownames(means.sds)<-c("normal.avg","amplified.avg","deleted.avg","normal.med","amplified.med","deleted.med")
colnames(means.sds)<-c("dchip.m","dchip.sd","illumina.m","illumina.sd","illumina.p.m","illumina.p.sd","bac.m","bac.sd","bac.p.m","bac.p.sd")
# table 1
means.sds
##
## Table 2
## Comparisons between methods
# First do smoothing
ridge.kappa<-0.0001
dc.smoothed<-matrix(NA,nrow=nrow(dc.data),ncol=ncol(dc.data),dimnames=dimnames(dc.data))
chroms<-unique(dc.chrompos[,"CHR"])
samples<-colnames(dc.data)
for (i1 in 1:length(samples) ) {
  for (chrom in chroms) {
    probes<-dc.chrompos[,"CHR"] == chrom
    if (sum(probes)>0) {
      dc.smoothed[probes,samples[i1]]<-quantsmooth(dc.data[probes,samples[i1]],smooth.lambda=dc.smooth.lambda,ridge.kappa=ridge.kappa,smooth.na=FALSE)
    }
  }
}
il.smoothed<-matrix(NA,nrow=nrow(il.data),ncol=ncol(il.data),dimnames=dimnames(il.data))
chroms<-unique(il.chrompos[,"CHR"])
samples<-colnames(il.data)
for (i1 in 1:length(samples) ) {
  for (chrom in chroms) {
    probes<-il.chrompos[,"CHR"] == chrom
    if (sum(probes)>0) {
      il.smoothed[probes,samples[i1]]<-quantsmooth(il.data[probes,samples[i1]],smooth.lambda=il.smooth.lambda,ridge.kappa=ridge.kappa,smooth.na=FALSE)
    }
  }
}
bac.smoothed<-matrix(NA,nrow=nrow(cn.bac),ncol=ncol(cn.bac),dimnames=dimnames(cn.bac))
chroms<-unique(chrompos.bac[,"CHR"])
samples<-colnames(cn.bac)
for (i1 in 1:length(samples) ) {
  for (chrom in chroms) {
    probes<-chrompos.bac[,"CHR"] == chrom
    if (sum(probes)>0) {
      bac.smoothed[probes,samples[i1]]<-quantsmooth(cn.bac[probes,samples[i1]],smooth.lambda=bac.smooth.lambda,ridge.kappa=ridge.kappa,smooth.na=FALSE)
    }
  }
}
## Put data in bins
binsize=2.5e6
dc.bins<-(dc.chrompos[,2] %/% binsize)*binsize / 1e6
il.bins<-(il.chrompos[,2] %/% binsize)*binsize / 1e6
bac.bins<-(chrompos.bac[,2] %/% binsize)*binsize / 1e6
dc.binned<-aggregate(dc.smoothed,by=list(chrom=dc.chrompos[,"CHR"],bin=dc.bins),mean,na.rm=TRUE)
rownames(dc.binned)<-paste("c",dc.binned[,1],"b",dc.binned[,2],sep="")
il.binned<-aggregate(il.smoothed,by=list(chrom=il.chrompos[,"CHR"],bin=il.bins),mean,na.rm=TRUE)
rownames(il.binned)<-paste("c",il.binned[,1],"b",il.binned[,2],sep="")
bac.binned<-aggregate(bac.smoothed,by=list(chrom=chrompos.bac[,"CHR"],bin=bac.bins),mean,na.rm=TRUE)
rownames(bac.binned)<-paste("c",bac.binned[,1],"b",bac.binned[,2],sep="")
# now put everything into 1 big matrix
mat.names<-unique(c(rownames(dc.binned),rownames(il.binned),rownames(bac.binned)))
all.binned<-matrix(NA,nrow=length(mat.names),ncol=12,dimnames=list(mat.names,
               c(paste("DC",colnames(dc.binned)[3:6],sep="."),
                 paste("IL",colnames(il.binned)[3:6],sep="."),
                 paste("BAC",colnames(bac.binned)[3:6],sep="."))))
pos.binned<-matrix(NA,nrow=length(mat.names),ncol=2,dimnames=list(mat.names,c("CHR","MapInfo")))
all.binned[rownames(dc.binned),1:4]<-as.matrix(dc.binned[,3:6])
pos.binned[rownames(dc.binned),]<-as.matrix(dc.binned[,1:2])
all.binned[rownames(il.binned),5:8]<-as.matrix(il.binned[,3:6])
pos.binned[rownames(il.binned),]<-as.matrix(il.binned[,1:2])
all.binned[rownames(bac.binned),9:12]<-as.matrix(bac.binned[,3:6])
pos.binned[rownames(bac.binned),]<-as.matrix(bac.binned[,1:2])
#
chroms<-1:22 # unique(pos.binned[,"CHR"])
chromcor.dc.bac<-matrix(NA,nrow=length(chroms),ncol=4)
chromdiffsd.dc.bac<-matrix(NA,nrow=length(chroms),ncol=4)
colnames(chromcor.dc.bac)<-colnames(il.data)
colnames(chromdiffsd.dc.bac)<-colnames(il.data)
chromcor.bac.il<-matrix(NA,nrow=length(chroms),ncol=4)
chromdiffsd.bac.il<-matrix(NA,nrow=length(chroms),ncol=4)
colnames(chromcor.bac.il)<-colnames(il.data)
colnames(chromdiffsd.bac.il)<-colnames(il.data)
chromcor.dc.il<-matrix(NA,nrow=length(chroms),ncol=4)
chromdiffsd.dc.il<-matrix(NA,nrow=length(chroms),ncol=4)
colnames(chromcor.dc.il)<-colnames(il.data)
colnames(chromdiffsd.dc.il)<-colnames(il.data)

for (i1 in 1:4 ) {
  for (chrom in 1:length(chroms)) {
    probes<-rownames(pos.binned)[pos.binned[,1] == chroms[chrom]]
    if (length(probes)>0) {
      chromcor.dc.bac[chrom,i1]<-cor(all.binned[probes,i1],all.binned[probes,i1+8],use="pairwise.complete.obs")
      chromdiffsd.dc.bac[chrom,i1]<-sd(all.binned[probes,i1]-all.binned[probes,i1+8],na.rm=TRUE)
      chromcor.bac.il[chrom,i1]<-cor(all.binned[probes,i1+4],all.binned[probes,i1+8],use="pairwise.complete.obs")
      chromdiffsd.bac.il[chrom,i1]<-sd(all.binned[probes,i1+4]-all.binned[probes,i1+8],na.rm=TRUE)
      chromcor.dc.il[chrom,i1]<-cor(all.binned[probes,i1],all.binned[probes,i1+4],use="pairwise.complete.obs")
      chromdiffsd.dc.il[chrom,i1]<-sd(all.binned[probes,i1]-all.binned[probes,i1+4],na.rm=TRUE)
    }
  }
}
##
## Correlations for 5 types of chromosomes
cor.diffsd<-c(mean(chromcor.dc.bac[categories=="c"]),mean(chromcor.dc.il[categories=="c"]),mean(chromcor.bac.il[categories=="c"]))
cor.diffsd<-rbind(cor.diffsd,c(mean(chromcor.dc.bac[categories=="u"]),mean(chromcor.dc.il[categories=="u"]),mean(chromcor.bac.il[categories=="u"])))
cor.diffsd<-rbind(cor.diffsd,c(mean(chromcor.dc.bac[categories=="n"]),mean(chromcor.dc.il[categories=="n"]),mean(chromcor.bac.il[categories=="n"])))
cor.diffsd<-rbind(cor.diffsd,c(mean(chromcor.dc.bac[categories=="a"]),mean(chromcor.dc.il[categories=="a"]),mean(chromcor.bac.il[categories=="a"])))
cor.diffsd<-rbind(cor.diffsd,c(mean(chromcor.dc.bac[categories=="d"]),mean(chromcor.dc.il[categories=="d"]),mean(chromcor.bac.il[categories=="d"])))
# Absolute differences
cor.diffsd<-rbind(cor.diffsd,c(mean(chromdiffsd.dc.bac[categories=="c"]),mean(chromdiffsd.dc.il[categories=="c"]),mean(chromdiffsd.bac.il[categories=="c"])))
cor.diffsd<-rbind(cor.diffsd,c(mean(chromdiffsd.dc.bac[categories=="u"]),mean(chromdiffsd.dc.il[categories=="u"]),mean(chromdiffsd.bac.il[categories=="u"])))
cor.diffsd<-rbind(cor.diffsd,c(mean(chromdiffsd.dc.bac[categories=="n"]),mean(chromdiffsd.dc.il[categories=="n"]),mean(chromdiffsd.bac.il[categories=="n"])))
cor.diffsd<-rbind(cor.diffsd,c(mean(chromdiffsd.dc.bac[categories=="a"]),mean(chromdiffsd.dc.il[categories=="a"]),mean(chromdiffsd.bac.il[categories=="a"])))
cor.diffsd<-rbind(cor.diffsd,c(mean(chromdiffsd.dc.bac[categories=="d"]),mean(chromdiffsd.dc.il[categories=="d"]),mean(chromdiffsd.bac.il[categories=="d"])))
colnames(cor.diffsd)<-c("dc.bac","dc.il","bac.il")
rownames(cor.diffsd)<-c("cor.c","cor.u","cor.n","cor.a","cor.d","diff.c","diff.u","diff.n","diff.a","diff.d")
## SDs for above
cor.sd<-c(sd(chromcor.dc.bac[categories=="c"]),sd(chromcor.dc.il[categories=="c"]),sd(chromcor.bac.il[categories=="c"]))
cor.sd<-rbind(cor.sd,c(sd(chromcor.dc.bac[categories=="u"]),sd(chromcor.dc.il[categories=="u"]),sd(chromcor.bac.il[categories=="u"])))
cor.sd<-rbind(cor.sd,c(sd(chromcor.dc.bac[categories=="n"]),sd(chromcor.dc.il[categories=="n"]),sd(chromcor.bac.il[categories=="n"])))
cor.sd<-rbind(cor.sd,c(sd(chromcor.dc.bac[categories=="a"]),sd(chromcor.dc.il[categories=="a"]),sd(chromcor.bac.il[categories=="a"])))
cor.sd<-rbind(cor.sd,c(sd(chromcor.dc.bac[categories=="d"]),sd(chromcor.dc.il[categories=="d"]),sd(chromcor.bac.il[categories=="d"])))
cor.sd<-rbind(cor.sd,c(sd(chromdiffsd.dc.bac[categories=="c"]),sd(chromdiffsd.dc.il[categories=="c"]),sd(chromdiffsd.bac.il[categories=="c"])))
cor.sd<-rbind(cor.sd,c(sd(chromdiffsd.dc.bac[categories=="u"]),sd(chromdiffsd.dc.il[categories=="u"]),sd(chromdiffsd.bac.il[categories=="u"])))
cor.sd<-rbind(cor.sd,c(sd(chromdiffsd.dc.bac[categories=="n"]),sd(chromdiffsd.dc.il[categories=="n"]),sd(chromdiffsd.bac.il[categories=="n"])))
cor.sd<-rbind(cor.sd,c(sd(chromdiffsd.dc.bac[categories=="a"]),sd(chromdiffsd.dc.il[categories=="a"]),sd(chromdiffsd.bac.il[categories=="a"])))
cor.sd<-rbind(cor.sd,c(sd(chromdiffsd.dc.bac[categories=="d"]),sd(chromdiffsd.dc.il[categories=="d"]),sd(chromdiffsd.bac.il[categories=="d"])))
colnames(cor.sd)<-c("dc.bac","dc.il","bac.il")
rownames(cor.sd)<-c("cor.c","cor.u","cor.n","cor.a","cor.d","diff.c","diff.u","diff.n","diff.a","diff.d")
# Table 2
cor.diffsd
cor.sd
#
cor.diffsd<-c(median(chromcor.dc.bac[categories=="c"]),median(chromcor.dc.il[categories=="c"]),median(chromcor.bac.il[categories=="c"]))
cor.diffsd<-rbind(cor.diffsd,c(median(chromcor.dc.bac[categories=="u"]),median(chromcor.dc.il[categories=="u"]),median(chromcor.bac.il[categories=="u"])))
cor.diffsd<-rbind(cor.diffsd,c(median(chromcor.dc.bac[categories=="n"]),median(chromcor.dc.il[categories=="n"]),median(chromcor.bac.il[categories=="n"])))
cor.diffsd<-rbind(cor.diffsd,c(median(chromcor.dc.bac[categories=="a"]),median(chromcor.dc.il[categories=="a"]),median(chromcor.bac.il[categories=="a"])))
cor.diffsd<-rbind(cor.diffsd,c(median(chromcor.dc.bac[categories=="d"]),median(chromcor.dc.il[categories=="d"]),median(chromcor.bac.il[categories=="d"])))
# Absolute differences
cor.diffsd<-rbind(cor.diffsd,c(median(chromdiffsd.dc.bac[categories=="c"]),median(chromdiffsd.dc.il[categories=="c"]),median(chromdiffsd.bac.il[categories=="c"])))
cor.diffsd<-rbind(cor.diffsd,c(median(chromdiffsd.dc.bac[categories=="u"]),median(chromdiffsd.dc.il[categories=="u"]),median(chromdiffsd.bac.il[categories=="u"])))
cor.diffsd<-rbind(cor.diffsd,c(median(chromdiffsd.dc.bac[categories=="n"]),median(chromdiffsd.dc.il[categories=="n"]),median(chromdiffsd.bac.il[categories=="n"])))
cor.diffsd<-rbind(cor.diffsd,c(median(chromdiffsd.dc.bac[categories=="a"]),median(chromdiffsd.dc.il[categories=="a"]),median(chromdiffsd.bac.il[categories=="a"])))
cor.diffsd<-rbind(cor.diffsd,c(median(chromdiffsd.dc.bac[categories=="d"]),median(chromdiffsd.dc.il[categories=="d"]),median(chromdiffsd.bac.il[categories=="d"])))
colnames(cor.diffsd)<-c("dc.bac","dc.il","bac.il")
rownames(cor.diffsd)<-c("cor.c","cor.u","cor.n","cor.a","cor.d","diff.c","diff.u","diff.n","diff.a","diff.d")
## SDs for above
cor.sd<-c(mad(chromcor.dc.bac[categories=="c"]),mad(chromcor.dc.il[categories=="c"]),mad(chromcor.bac.il[categories=="c"]))
cor.sd<-rbind(cor.sd,c(mad(chromcor.dc.bac[categories=="u"]),mad(chromcor.dc.il[categories=="u"]),mad(chromcor.bac.il[categories=="u"])))
cor.sd<-rbind(cor.sd,c(mad(chromcor.dc.bac[categories=="n"]),mad(chromcor.dc.il[categories=="n"]),mad(chromcor.bac.il[categories=="n"])))
cor.sd<-rbind(cor.sd,c(mad(chromcor.dc.bac[categories=="a"]),mad(chromcor.dc.il[categories=="a"]),mad(chromcor.bac.il[categories=="a"])))
cor.sd<-rbind(cor.sd,c(mad(chromcor.dc.bac[categories=="d"]),mad(chromcor.dc.il[categories=="d"]),mad(chromcor.bac.il[categories=="d"])))
cor.sd<-rbind(cor.sd,c(mad(chromdiffsd.dc.bac[categories=="c"]),mad(chromdiffsd.dc.il[categories=="c"]),mad(chromdiffsd.bac.il[categories=="c"])))
cor.sd<-rbind(cor.sd,c(mad(chromdiffsd.dc.bac[categories=="u"]),mad(chromdiffsd.dc.il[categories=="u"]),mad(chromdiffsd.bac.il[categories=="u"])))
cor.sd<-rbind(cor.sd,c(mad(chromdiffsd.dc.bac[categories=="n"]),mad(chromdiffsd.dc.il[categories=="n"]),mad(chromdiffsd.bac.il[categories=="n"])))
cor.sd<-rbind(cor.sd,c(mad(chromdiffsd.dc.bac[categories=="a"]),mad(chromdiffsd.dc.il[categories=="a"]),mad(chromdiffsd.bac.il[categories=="a"])))
cor.sd<-rbind(cor.sd,c(mad(chromdiffsd.dc.bac[categories=="d"]),mad(chromdiffsd.dc.il[categories=="d"]),mad(chromdiffsd.bac.il[categories=="d"])))
colnames(cor.sd)<-c("dc.bac","dc.il","bac.il")
rownames(cor.sd)<-c("cor.c","cor.u","cor.n","cor.a","cor.d","diff.c","diff.u","diff.n","diff.a","diff.d")
cor.diffsd
cor.sd
##
# Table 2, first column
#
data.nrmp<-standardNormalization(rawdata)
data.nrmp<-data.nrmp[,c("106NB","106TV","106TP","108NB","108TV","108TP","44NB","44TV","44TP","514NB","514TV","514TP")]
ridge.kappa<-0.0001
int.smoothed<-matrix(NA,nrow=nrow(data.nrmp),ncol=ncol(data.nrmp),dimnames=list(featureNames(data.nrmp),sampleNames(data.nrmp))) 
chroms<-unique(reporterInfo(data.nrmp)[,"CHR"])
samples<-sampleNames(data.nrmp)
for (i1 in 1:length(samples) ) {
  for (chrom in chroms) {
    probes<-reporterInfo(data.nrmp)[,"CHR"] == chrom
    if (sum(is.na(assayData(data.nrmp)[["intensity"]][probes,samples[i1]])<10) & sum(probes)>10) {
      int.smoothed[probes,samples[i1]]<-quantsmooth(assayData(data.nrmp)[["intensity"]][probes,samples[i1]],smooth.lambda=il.smooth.lambda,ridge.kappa=ridge.kappa,smooth.na=FALSE)
    }
  }
}
chroms<-1:22
categories<-read.table("Analysis/ChangedChromosomes.txt",sep="\t",header=TRUE,row.names=1,as.is=TRUE)[,c(2,3,1,4)]
allcategories<-list(as.vector(as.matrix(categories)))
# compare frozen, paraffin
chromcors<-matrix(NA,nrow=length(chroms),ncol=4)
chromdiffsd<-matrix(NA,nrow=length(chroms),ncol=4)
colnames(chromcors)<-c("X106","X108","X44","X514")
colnames(chromdiffsd)<-c("X106","X108","X44","X514")
# frozen normal
chromcors.f<-matrix(NA,nrow=length(chroms),ncol=4)
chromdiffsd.f<-matrix(NA,nrow=length(chroms),ncol=4)
colnames(chromcors.f)<-c("X106","X108","X44","X514")
colnames(chromdiffsd.f)<-c("X106","X108","X44","X514")
# para
chromcors.p<-matrix(NA,nrow=length(chroms),ncol=4)
chromdiffsd.p<-matrix(NA,nrow=length(chroms),ncol=4)
colnames(chromcors.p)<-c("X106","X108","X44","X514")
colnames(chromdiffsd.p)<-c("X106","X108","X44","X514")

F.cols<-c(2,5,8,11)

for (i1 in 1:4) {
  for (chrom in 1:length(chroms)) {
    probes<-reporterInfo(data.nrmp)[,"CHR"] == chroms[chrom]
    if (length(probes)>0 & sum(!is.na(int.smoothed[probes,F.cols[i1]]))>10 & sum(!is.na(int.smoothed[probes,F.cols[i1]+1]))>10) {
      chromcors[chrom,i1]<-cor(int.smoothed[probes,F.cols[i1]],int.smoothed[probes,F.cols[i1]+1],use="pairwise.complete.obs")
      chromdiffsd[chrom,i1]<-mean(abs(int.smoothed[probes,F.cols[i1]]-int.smoothed[probes,F.cols[i1]+1]),na.rm=TRUE)
    }
    if (length(probes)>0 & sum(!is.na(int.smoothed[probes,F.cols[i1]]))>10 & sum(!is.na(int.smoothed[probes,F.cols[i1]-1]))>10) {
      chromcors.f[chrom,i1]<-cor(int.smoothed[probes,F.cols[i1]],int.smoothed[probes,F.cols[i1]-1],use="pairwise.complete.obs")
      chromdiffsd.f[chrom,i1]<-mean(abs(int.smoothed[probes,F.cols[i1]]-int.smoothed[probes,F.cols[i1]-1]),na.rm=TRUE)
    }
    if (length(probes)>0 & sum(!is.na(int.smoothed[probes,F.cols[i1-1]]))>10 & sum(!is.na(int.smoothed[probes,F.cols[i1]+1]))>10) {
      chromcors.p[chrom,i1]<-cor(int.smoothed[probes,F.cols[i1-1]],int.smoothed[probes,F.cols[i1]+1],use="pairwise.complete.obs")
      chromdiffsd.p[chrom,i1]<-mean(abs(int.smoothed[probes,F.cols[i1-1]]-int.smoothed[probes,F.cols[i1]+1]),na.rm=TRUE)
    }
  }
}


chromcor.parfrozen<-aggregate(as.vector(chromcors),by=allcategories,FUN=mean,na.rm=TRUE)
chromcor.parfrozen<-cbind(chromcor.parfrozen,aggregate(as.vector(chromcors),by=allcategories,FUN=sd,na.rm=TRUE)[,2])
chromcor.parfrozen<-cbind(chromcor.parfrozen,aggregate(as.vector(chromcors),by=allcategories,FUN=median,na.rm=TRUE)[,2])
chromcor.parfrozen<-cbind(chromcor.parfrozen,aggregate(as.vector(chromcors),by=allcategories,FUN=mad,na.rm=TRUE)[,2])

chromcor.parfrozen<-cbind(chromcor.parfrozen,aggregate(as.vector(chromdiffsd),by=allcategories,FUN=mean,na.rm=TRUE)[,2])
chromcor.parfrozen<-cbind(chromcor.parfrozen,aggregate(as.vector(chromdiffsd),by=allcategories,FUN=sd,na.rm=TRUE)[,2])
chromcor.parfrozen<-cbind(chromcor.parfrozen,aggregate(as.vector(chromdiffsd),by=allcategories,FUN=median,na.rm=TRUE)[,2])
chromcor.parfrozen<-cbind(chromcor.parfrozen,aggregate(as.vector(chromdiffsd),by=allcategories,FUN=mad,na.rm=TRUE)[,2])
colnames(chromcor.parfrozen)<-c("Cat","corr.avg","corr.sd","corr.med","corr.mad","diff.avg","diff.sd","diff.med","diff.mad")
chromcor.parfrozen
#
## Exclude T44
categories.m44<-categories[,-3]
chromcors.m44<-chromcors[,-3]
chromdiffsd.m44<-chromdiffsd[,-3]
allcategories<-list(as.vector(as.matrix(categories.m44)))

chromcor.parfrozen<-aggregate(as.vector(chromcors.m44),by=allcategories,FUN=mean,na.rm=TRUE)
chromcor.parfrozen<-cbind(chromcor.parfrozen,aggregate(as.vector(chromcors.m44),by=allcategories,FUN=sd,na.rm=TRUE)[,2])
chromcor.parfrozen<-cbind(chromcor.parfrozen,aggregate(as.vector(chromcors.m44),by=allcategories,FUN=median,na.rm=TRUE)[,2])
chromcor.parfrozen<-cbind(chromcor.parfrozen,aggregate(as.vector(chromcors.m44),by=allcategories,FUN=mad,na.rm=TRUE)[,2])

chromcor.parfrozen<-cbind(chromcor.parfrozen,aggregate(as.vector(chromdiffsd.m44),by=allcategories,FUN=mean,na.rm=TRUE)[,2])
chromcor.parfrozen<-cbind(chromcor.parfrozen,aggregate(as.vector(chromdiffsd.m44),by=allcategories,FUN=sd,na.rm=TRUE)[,2])
chromcor.parfrozen<-cbind(chromcor.parfrozen,aggregate(as.vector(chromdiffsd.m44),by=allcategories,FUN=median,na.rm=TRUE)[,2])
chromcor.parfrozen<-cbind(chromcor.parfrozen,aggregate(as.vector(chromdiffsd.m44),by=allcategories,FUN=mad,na.rm=TRUE)[,2])
colnames(chromcor.parfrozen)<-c("Cat","corr.avg","corr.sd","corr.med","corr.mad","diff.avg","diff.sd","diff.med","diff.mad")
chromcor.parfrozen

