# Figure 4: chromosome plots
setwd("/cn_data")
library(beadarraySNP)
load("Analysis/1280260raw.RData")
## BAC array data
load("Analysis/bacdata.RData")
# default levels for lambda. Dependent on total number of autosomal probes
lambda.divisor<-1500
il.smooth.lambda<-5469/lambda.divisor
bac.smooth.lambda<-3307/lambda.divisor
data.nrmp<-standardNormalization(all.260)

pdf("figure4.pdf",width=8,height=11)
markersize<-2
xscale<-c(0,(lengthChromosome(5,"bases")+lengthChromosome(17,"bases"))*1.05)
yscale<-c(0,2.8)
ideo.width<-0.15
ideo.ypos<-ideo.width  #2+(ideo.width/2)
ideo.bleach<-0.0
par(mfrow=c(3,1),mar=c(1,3,1,1))                        
################################################################################
## panel A-B: X and Y-chromosome from normal samples
################################################################################
plot(xscale,yscale,type="n",main="",ylab="intensity",xlab="",xaxt="n")
abline(h=2)
paintCytobands("X",c(0,ideo.ypos),"bases",width=ideo.width,legend=FALSE,bleach=ideo.bleach)
probes<-reporterInfo(data.nrmp)[,"CHR"]=="X"
plotSmoothed(assayData(data.nrmp)[["intensity"]][probes,c("44NB","514NB","106NB","108NB")],
    reporterInfo(data.nrmp)[probes,"MapInfo"],smooth.lambda=il.smooth.lambda,cex.pts=0.2,plotnew=FALSE)
legend("topleft","A",bty="n")
legend("topright","Figure 4       ",bty="n")
##
probes<-reporterInfo(data.nrmp)[,"CHR"]=="Y"
xbase<-xscale[2]-lengthChromosome("Y","bases")
paintCytobands("Y",c(xbase,2+(ideo.width/2)),"bases",width=ideo.width,legend=FALSE,bleach=ideo.bleach)
plotSmoothed(assayData(data.nrmp)[["intensity"]][probes,c("44NB","514NB","106NB","108NB")],
    reporterInfo(data.nrmp)[probes,"MapInfo"]+xbase,smooth.lambda=il.smooth.lambda,cex.pts=0.2,plotnew=FALSE)
legend("topright","B",bty="n")
abline(v=(lengthChromosome("X","bases")+xbase)/2)
################################################################################
## Panel C - E tumor chromosomes Frozen/Paraffin
################################################################################
useQuality<-TRUE
threshold<-0.8
relative<-TRUE
percentile<-FALSE
hetero.n<-heterozygousSNPs(data.nrmp[,c("106NB","108NB","514NB","44NB")],useQuality=useQuality,threshold=threshold,relative=relative,percentile=percentile)
hetero.t<-heterozygousSNPs(data.nrmp[,c("106TV","108TV","514TV","44TV")],useQuality=useQuality,threshold=threshold,relative=relative,percentile=percentile)
## Plots
# 106 chrom 17
plot(xscale,yscale,type="n",main="",ylab="intensity",xlab="",xaxt="n")
abline(h=2)
paintCytobands(17,pos=c(0,ideo.ypos),units="bases",width=ideo.width,legend=FALSE,bleach=ideo.bleach)
probes<-reporterInfo(data.nrmp)[,"CHR"]==17
plotSmoothed(assayData(data.nrmp)[["intensity"]][probes,c("106TV","106TP")],
    position=reporterInfo(data.nrmp)[probes,"MapInfo"],smooth.lambda=il.smooth.lambda,cex.pts=0.2,plotnew=FALSE)
proberows<-featureNames(data.nrmp)[probes]
loh<-compareGenotypes(hetero.t[proberows,1],hetero.n[proberows,1])
loci.loh<-proberows[loh=="l"]
loci.art<-proberows[loh=="i"]
points(reporterInfo(data.nrmp)[loci.art,"MapInfo"],rep(0.4,length(loci.art)),pch="|",font=2,col="lightgrey",cex=markersize)
points(reporterInfo(data.nrmp)[loci.loh,"MapInfo"],rep(0.4,length(loci.loh)),pch="|",font=2,col="black",cex=markersize)
legend("topleft","C",bty="n")
# 44 chrom 5
xbase<-xscale[2]-lengthChromosome(5,"bases")
paintCytobands(5,pos=c(xbase,ideo.ypos),units="bases",width=ideo.width,legend=FALSE,bleach=ideo.bleach)
probes<-reporterInfo(data.nrmp)[,"CHR"]==5
plotSmoothed(assayData(data.nrmp)[["intensity"]][probes,c("44TV","44TP")],
    reporterInfo(data.nrmp)[probes,"MapInfo"]+xbase,smooth.lambda=il.smooth.lambda,cex.pts=0.2,plotnew=FALSE)
proberows<-featureNames(data.nrmp)[probes]
# bac
probes<-chrompos.bac[,"CHR"]==5
plotSmoothed(cn.bac[probes,c("44TV","44TP")],chrompos.bac[probes,"MapInfo"]+xbase,
    smooth.lambda=bac.smooth.lambda,plotnew=FALSE,cex.pts=0.2,cols=c("cyan","blue"))
#
loh<-compareGenotypes(hetero.t[proberows,4],hetero.n[proberows,4])
loci.loh<-proberows[loh=="l"]
loci.art<-proberows[loh=="i"]
points(reporterInfo(data.nrmp)[loci.art,"MapInfo"]+xbase,rep(0.4,length(loci.art)),pch="|",font=2,col="lightgrey",cex=markersize)
points(reporterInfo(data.nrmp)[loci.loh,"MapInfo"]+xbase,rep(0.4,length(loci.loh)),pch="|",font=2,col="black",cex=markersize)
legend("topright","D",bty="n")
abline(v=(lengthChromosome("17","bases")+xbase)/2)
# 514 chrom 2
plot(xscale,yscale,type="n",main="",ylab="intensity",xlab="",xaxt="n")
abline(h=2)
paintCytobands(2,pos=c(0,ideo.ypos),units="bases",width=ideo.width,legend=FALSE,bleach=ideo.bleach)
probes<-reporterInfo(data.nrmp)[,"CHR"]==2
plotSmoothed(assayData(data.nrmp)[["intensity"]][probes,c("514TV","514TP")],xaxt="n",main="",
    reporterInfo(data.nrmp)[probes,"MapInfo"],smooth.lambda=il.smooth.lambda,cex.pts=0.2,plotnew=FALSE)
proberows<-featureNames(data.nrmp)[probes]
loh<-compareGenotypes(hetero.t[proberows,3],hetero.n[proberows,3])
loci.loh<-proberows[loh=="l"]
loci.art<-proberows[loh=="i"]
points(reporterInfo(data.nrmp)[loci.art,"MapInfo"],rep(0.4,length(loci.art)),pch="|",font=2,col="lightgrey",cex=markersize)
points(reporterInfo(data.nrmp)[loci.loh,"MapInfo"],rep(0.4,length(loci.loh)),pch="|",font=2,col="black",cex=markersize)
legend("topleft","E",bty="n")
dev.off()

