# Analysis of Illumina SNP data
##
##
##
## Set the working directory to the root of Analysis, ProcessedData and Rawdata
##
##
##
setwd("/cn_data")
library(beadarraySNP)
load("Analysis/1280260raw.RData")
# default levels for lambda. Dependent on total number of autosomal probes
lambda.divisor<-1500
il.smooth.lambda<-5469/lambda.divisor
dc.smooth.lambda<-9800/lambda.divisor
bac.smooth.lambda<-3307/lambda.divisor
probes<-numericCHR(reporterInfo(all.260)[,"CHR"])<90
rawdata<-all.260[probes,]
data.nrmp<-standardNormalization(rawdata)
il.data<-assayData(data.nrmp)[["intensity"]][,c("44TV","106TV","108TV","514TV")]
il.data.p<-assayData(data.nrmp)[["intensity"]][,c("44TP","106TP","108TP","514TP")]
il.chrompos<- cbind(CHR=numericCHR(reporterInfo(data.nrmp)[,"CHR"]),MapInfo=reporterInfo(data.nrmp)["MapInfo"])
rownames(il.chrompos)<-rownames(il.data)
##  Load dCHIP data (affymetrix)
load("Analysis/dchipCN.RData")
## BAC array data
load("Analysis/bacdata.RData")
probes<-chrompos.bac[,1]<23
cn.bac.par<-cn.bac[probes,c("44TP","106TP","108TV","514TP")]
cn.bac.par[,"108TV"]<-NA
cn.bac<-cn.bac[probes,c("44TV","106TV","108TV","514TV")]
chrompos.bac<-chrompos.bac[probes,]
## combine
chrompos<-rbind(dc.chrompos,il.chrompos,chrompos.bac)
idx<-order(chrompos[,1],chrompos[,2])
chrompos<-chrompos[idx,]
##
## Figure 3
##
pdf("figure3.pdf",width=8,height=11)
useQuality<-TRUE
relative<-TRUE
percentile<-FALSE
showparaffin<-FALSE
threshold<-0.8
hetero.t<-heterozygousSNPs(data.nrmp[,c("44TV","106TV","108TV","514TV")],useQuality=useQuality,threshold=threshold,relative=relative,percentile=percentile)
hetero.n<-heterozygousSNPs(data.nrmp[,c("44NB","106NB","108NB","514NB")],useQuality=useQuality,threshold=threshold,relative=relative,percentile=percentile)
for (smp in 2) {   # use 1:4 for all samples
  dchrompos<-prepareGenomePlot(chrompos,main="",paintCytobands=TRUE,bleach=0.7,topspace=0,organism="hsa")
  for (chrom in unique(chrompos[,1])) {
    probes <- chrompos[,1] == chrom & rownames(chrompos) %in% rownames(dc.data)
    smoothed<-quantsmooth(dc.data[rownames(chrompos[probes,]),smp],smooth.lambda=dc.smooth.lambda)
    lines(dchrompos[probes,2],dchrompos[probes,1]+(smoothed/2)-1,col=2,lwd=2)
    #
    probes <- chrompos[,1] == chrom & rownames(chrompos) %in% rownames(il.data)
    proberows<-rownames(chrompos[probes,])
    if (sum(!is.na(il.data[proberows,smp]))>10) {
      smoothed<-quantsmooth(il.data[proberows,smp],smooth.lambda=il.smooth.lambda)
      lines(dchrompos[probes,2],dchrompos[probes,1]+(smoothed/2)-1,col=4,lwd=2)
    }
    if (showparaffin & sum(!is.na(il.data.p[proberows,smp]))>10) {
      smoothed<-quantsmooth(il.data.p[proberows,smp],smooth.lambda=il.smooth.lambda)
      lines(dchrompos[probes,2],dchrompos[probes,1]+(smoothed/2)-1,col="yellow",lwd=2)
    }
    #
    loh<-compareGenotypes(hetero.t[proberows,smp],hetero.n[proberows,smp])
    loci.loh<-proberows[loh=="l"]
    loci.art<-proberows[loh=="i"]
    points(dchrompos[loci.art,2],dchrompos[loci.art,1]-0.5,pch="|",font=2,col="lightgrey",cex=0.7)
    points(dchrompos[loci.loh,2],dchrompos[loci.loh,1]-0.5,pch="|",font=2,col="black",cex=0.7)
    #
    probes <- chrompos[,1] == chrom & rownames(chrompos) %in% rownames(cn.bac)
    smoothed<-quantsmooth(cn.bac[rownames(chrompos[probes,]),smp],smooth.lambda=bac.smooth.lambda)
    lines(dchrompos[probes,2],dchrompos[probes,1]+(smoothed/2)-1,col=3,lwd=2)
    #
    if (showparaffin) {
      smoothed<-quantsmooth(cn.bac.par[rownames(chrompos[probes,]),smp],smooth.lambda=bac.smooth.lambda)
      lines(dchrompos[probes,2],dchrompos[probes,1]+(smoothed/2)-1,col=5,lwd=2)
    }
  }
  legend("topright","Figure 3",bty="n")
}
dev.off()
