# Figure 1 of paper for illumina copynumber technology
# 4 subpanels a-d
# - a: raw red and green distributions (density plots)
# - b: theoretical single allele distribution
# - c: Scatterplot of SNPs on red and green intensity
# - d: density of angle
library(beadarraySNP)
##
##
##
## Set the working directory to the root of Analysis, ProcessedData and Rawdata
##
##
##
setwd("/cn_data")
linescontinuoushist<-function(res,...) {
  segments(res$breaks[-1],res$counts,res$breaks[-length(res$breaks)],res$counts,...)
  segments(res$breaks,c(0,res$counts),res$breaks,c(res$counts,0),...)
}
#
clip<-function(x,limits) {
  x[x<limits[1]]<-limits[1]
  x[x>limits[2]]<-limits[2]
  x
}
# 
load("Analysis/1280260raw.RData")
# use this sample throughout
datacol<-"511NB"
OPA<-"GS0005702-OPA"
datarows<-reporterInfo(all.260)[,"OPA"]==OPA
green<-assayDataElement(all.260,"G")[datarows,datacol]
red<-assayDataElement(all.260,"R")[datarows,datacol]
heterozyg<-assayDataElement(all.260,"call")[datarows,datacol]=="H"
homozygG<-assayDataElement(all.260,"call")[datarows,datacol]=="B"
homozygR<-assayDataElement(all.260,"call")[datarows,datacol]=="A"
pdf("figure1.pdf",width=10,height=7)
par(mfrow=c(2,2),mar=c(4.2,4,0.5,0.7))
# panel a
hist.breaks<-75
hist.range<-25000
breaks<-0 : hist.breaks * (hist.range / hist.breaks)
hist.sum<-hist((green+red),breaks=breaks,plot=FALSE)
hist.g<-hist(green,breaks=breaks,plot=FALSE)
hist.r<-hist(red,breaks=breaks,plot=FALSE)
ymax<-max(c(hist.sum$counts,hist.g$counts,hist.r$counts))
plot(c(0,25000),c(0,ymax),main="",ylab="counts",xlab="intensity",type="n")
linescontinuoushist(hist.g,col="green",lwd=2)
linescontinuoushist(hist.r,col="red",lwd=2)
linescontinuoushist(hist.sum,col="black",lwd=2)
legend("topleft","A",bty="n")
# panel b
additivenoise=0.15
multiplicativenoise=0.4
n=50000
hist.breaks<-100
hist.range<-c(-2,7)
allele0<-sum(homozygG)/length(green)
allele1<-sum(heterozyg)/length(green)
allele2<-sum(homozygR)/length(green)
a0<-clip(rnorm(n*allele0,mean=0,sd=additivenoise),hist.range)
a1<-clip(rnorm(n*allele1,mean=1,sd=additivenoise+multiplicativenoise),hist.range)
a2<-clip(rnorm(n*allele2,mean=2,sd=additivenoise+multiplicativenoise+multiplicativenoise),hist.range)
breaks<-seq(from=hist.range[1],to=hist.range[2],length.out=hist.breaks+1)
hist.a0<-hist(a0,breaks=breaks,plot=FALSE)
hist.a1<-hist(a1,breaks=breaks,plot=FALSE)
hist.a2<-hist(a2,breaks=breaks,plot=FALSE)
ymax<-max(hist.a0$counts+hist.a1$counts+hist.a2$counts)
plot(c(-1,5),c(0,ymax),col="black",type="n",ylab="counts",xlab="allele count",lwd=2,xaxt="n")
axis(1,at=c(0,1,2))
linescontinuoushist(hist.a0,col="red",lwd=2)
linescontinuoushist(hist.a1,col="orange",lwd=2)
linescontinuoushist(hist.a2,col="blue",lwd=2)
linescontinuoushist(list(breaks=hist.a0$breaks,counts=hist.a0$counts+hist.a1$counts+hist.a2$counts),col="black",lwd=2)
scaling<-n/20
lines(c(0,0),c(0,allele0*scaling),col="red",lwd=4)
lines(c(1,1),c(0,allele1*scaling),col="orange",lwd=4)
lines(c(2,2),c(0,allele2*scaling),col="blue",lwd=4)
legend("topleft","B",bty="n")
# panel c
plot(green,red,main="",type="n",xlab="intensity Cy3",ylab="intensity Cy5")
points(green[homozygG],red[homozygG],col="red",pch=20)
points(green[homozygR],red[homozygR],col="green",pch=20)
points(green[heterozyg],red[heterozyg],col="yellow",pch=20)
legend("topleft","C",bty="n")
# panel d
polar<-RG2polar(all.260[datarows,datacol])
hist.p<-hist(assayDataElement(polar,"theta"),breaks=100,plot=FALSE)
ew<-0.0
plot(c(0,pi/2),c(0,max(hist.p$counts)),main="",xaxt="n",lwd=2,xlab="angle",ylab="counts",type="n")
linescontinuoushist(hist.p,col="black",lwd=2)
axis(1,at=c(0,pi/8,pi/4,3*pi/8,pi/2),expression(0,pi/8,pi/4,3*pi/8,pi/2))
maxangle<- 0.3
probes<-hist.p$breaks<maxangle
density.p.r.x<-hist.p$mids[probes]
mode.p.r<-density.p.r.x[which.max(hist.p$counts[probes])]
probes<-hist.p$breaks>(pi/2 -maxangle)
density.p.g.x<-hist.p$mids[probes]
mode.p.g<-density.p.g.x[which.max(hist.p$counts[probes])]
abline(v=c(0,pi/2))
abline(v=c(mode.p.r,mode.p.g),col=c("red","green"),lwd=2)
legend("topleft","D",bty="n")
dev.off()


