/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.StringTokenizer;

public class Write_Pathway_Summary_Information {
    private fileout pathway_summary_file;
    private filein original_pathway_file;
    private double Percent;
    private double Significance;
    private int geneCount;
    private int total_number_of_genes_in_pathway;
    private double P;
    private double G;
    private double Cp;
    private double Cg;
    private double Fisher_Exact_Test = 0.0;
    private double t_test = 0.0;
    private double Upregulation_Downregulation_of_Pathway = 0.0;
    private double p_value_for_t_test = 0.0;
    private double unsigned_t_test = 0.0;
    private double p_value_for_unsigned_t_test = 0.0;

    public void writePathwaySummary() throws IOException {
        this.pathway_summary_file = new fileout(SystemData.path + PathwayData.pathway_summary_file);
        this.original_pathway_file = new filein(new String(SystemData.path + PathwayData.pathway_matrix_file));
        this.original_pathway_file.file_lineread();
        StringTokenizer stringTokenizer = new StringTokenizer(this.original_pathway_file.currentline);
        stringTokenizer.hasMoreTokens();
        stringTokenizer.nextToken("\t");
        this.pathway_summary_file.file_linewrite(new String("Genes in Pathway present in the Data File\t" + new String("Genes exceeding Fold Change Cutoff ( " + Double.toString(CutoffData.Fisher_FoldChange_LowerCutoff) + ", " + Double.toString(CutoffData.Fisher_FoldChange_UpperCutoff) + " )") + "\t" + new String("Fisher Exact Test ( " + Double.toString(CutoffData.Fisher_FoldChange_LowerCutoff) + ", " + Double.toString(CutoffData.Fisher_FoldChange_UpperCutoff) + " )") + "\t" + new String("Upregulation/Downregulation of Pathway ( " + Double.toString(CutoffData.Fisher_FoldChange_LowerCutoff) + ", " + Double.toString(CutoffData.Fisher_FoldChange_UpperCutoff) + " )") + "\t" + new String("Signed Fisher Exact Test ( " + Double.toString(CutoffData.Fisher_FoldChange_LowerCutoff) + ", " + Double.toString(CutoffData.Fisher_FoldChange_UpperCutoff) + " )") + "\t" + "Pathway"));
        int n = 0;
        double[] dArray = new double[PathwayData.number_of_pathways];
        int[] nArray = new int[PathwayData.number_of_pathways];
        int[] nArray2 = new int[PathwayData.number_of_pathways];
        double[] dArray2 = new double[PathwayData.number_of_pathways];
        double[] dArray3 = new double[PathwayData.number_of_pathways];
        double[] dArray4 = new double[PathwayData.number_of_pathways];
        String[] stringArray = new String[PathwayData.number_of_pathways];
        while (stringTokenizer.hasMoreTokens()) {
            this.geneCount = PathwayData.foldchanges_perPathway[n].size();
            this.total_number_of_genes_in_pathway = Integer.valueOf((String)PathwayData.total_genes_per_pathway.elementAt(n));
            this.Percent = (double)this.geneCount * 100.0 / (double)this.total_number_of_genes_in_pathway;
            this.Significance = (double)this.geneCount / (double)this.total_number_of_genes_in_pathway / ((double)PathwayData.total_expressed_genes / (double)PathwayData.number_of_genes);
            dArray[n] = this.Percent;
            nArray[n] = this.geneCount;
            dArray2[n] = this.Significance;
            stringArray[n] = new String(stringTokenizer.nextToken("\t"));
            nArray2[n] = this.total_number_of_genes_in_pathway;
            ++n;
        }
        int n2 = 0;
        while (n2 < PathwayData.number_of_pathways) {
            this.P = Integer.valueOf((String)PathwayData.genes_per_pathway_from_data_file.elementAt(n2)).intValue();
            this.G = PathwayData.total_number_of_genes_in_data_file;
            this.Cp = nArray[n2];
            this.Cg = PathwayData.total_expressed_genes;
            this.Fisher_Exact_Test = Pathway_Summary_Calculator.get_Fisher_Exact_Test(this.P, this.G, this.Cg, this.Cp);
            this.Upregulation_Downregulation_of_Pathway = Pathway_Summary_Calculator.get_average_inside_outside(n2);
            this.pathway_summary_file.file_linewrite(new String(new DecimalFormat("#").format(this.P) + "\t" + new DecimalFormat("#").format(this.Cp) + "\t" + Double.toString(this.Fisher_Exact_Test) + "\t" + Double.toString(this.Upregulation_Downregulation_of_Pathway) + "\t" + Double.toString(Write_Pathway_Summary_Information.convertToFisherVector(this.Fisher_Exact_Test, this.Upregulation_Downregulation_of_Pathway)) + "\t" + stringArray[n2]));
            ++n2;
        }
        this.pathway_summary_file.file_close();
        this.original_pathway_file.file_close();
    }

    private static double convertToFisherVector(double d, double d2) {
        if (d2 > 0.0) {
            d *= 1.0;
        }
        if (d2 < 0.0 && (d *= -1.0) >= -1.0E-4) {
            d = -1.0E-4;
        }
        if (d2 == 0.0) {
            d = 1.0;
        }
        return d;
    }
}

