/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.transport.tcp;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.rmi.ConnectIOException;
import java.rmi.RemoteException;
import java.rmi.server.LogStream;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.RMISocketFactory;
import java.security.AccessController;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import sun.applet.AppletSecurityException;
import sun.rmi.transport.Channel;
import sun.rmi.transport.Endpoint;
import sun.rmi.transport.RMIThreadAction;
import sun.rmi.transport.Target;
import sun.rmi.transport.Transport;
import sun.rmi.transport.tcp.TCPTransport;
import sun.security.action.GetBooleanAction;
import sun.security.action.GetIntegerAction;
import sun.security.action.GetPropertyAction;

public class TCPEndpoint
implements Endpoint {
    private String host;
    private int port;
    private RMIClientSocketFactory csf = null;
    private RMIServerSocketFactory ssf = null;
    private TCPTransport thisTransport = null;
    private static String localHost;
    private static boolean localHostKnown;
    private static Object localHostLock;
    private static Hashtable localEndpoints;
    private static final int FORMAT_HOST_PORT = 0;
    private static final int FORMAT_HOST_PORT_FACTORY = 1;

    private static int getInt(String string, int n) {
        return (Integer)AccessController.doPrivileged(new GetIntegerAction(string, n));
    }

    private static boolean getBoolean(String string) {
        return (Boolean)AccessController.doPrivileged(new GetBooleanAction(string));
    }

    public TCPEndpoint(String string, int n) {
        if (string == null) {
            string = "";
        }
        this.host = string;
        this.port = n;
    }

    public TCPEndpoint(String string, int n, RMIClientSocketFactory rMIClientSocketFactory, RMIServerSocketFactory rMIServerSocketFactory) {
        this(string, n);
        this.csf = rMIClientSocketFactory;
        this.ssf = rMIServerSocketFactory;
    }

    public static TCPEndpoint getLocalEndpoint(int n) {
        return TCPEndpoint.getLocalEndpoint(n, null, null);
    }

    public static TCPEndpoint getLocalEndpoint(int n, RMIClientSocketFactory rMIClientSocketFactory, RMIServerSocketFactory rMIServerSocketFactory) {
        TCPEndpoint tCPEndpoint = null;
        Hashtable hashtable = localEndpoints;
        synchronized (hashtable) {
            TCPEndpoint tCPEndpoint2 = new TCPEndpoint(null, n, rMIClientSocketFactory, rMIServerSocketFactory);
            tCPEndpoint = (TCPEndpoint)localEndpoints.get(tCPEndpoint2);
            if (tCPEndpoint == null) {
                tCPEndpoint = new TCPEndpoint(TCPEndpoint.getLocalHost(), n, rMIClientSocketFactory, rMIServerSocketFactory);
                tCPEndpoint.thisTransport = new TCPTransport(tCPEndpoint);
                localEndpoints.put(tCPEndpoint2, tCPEndpoint);
                if (TCPTransport.logLevel >= 10) {
                    LogStream.log("tcp").println("TCPEndpoint.getLocalEndpoint: created local endpoint for socket factory " + rMIServerSocketFactory + " on port " + n);
                }
            }
        }
        return tCPEndpoint;
    }

    static String getLocalHost() {
        Object object = localHostLock;
        synchronized (object) {
            String string = localHost;
            return string;
        }
    }

    static void setLocalHost(String string) {
        Object object = localHostLock;
        synchronized (object) {
            if (!localHostKnown) {
                localHost = string;
                localHostKnown = true;
                if (TCPTransport.logLevel >= 10) {
                    LogStream.log("tcp").println("TCPEndpoint.setLocalHost: local host set to " + string);
                }
            } else {
                return;
            }
        }
        Hashtable hashtable = localEndpoints;
        synchronized (hashtable) {
            Enumeration enumeration = localEndpoints.elements();
            while (enumeration.hasMoreElements()) {
                TCPEndpoint tCPEndpoint = (TCPEndpoint)enumeration.nextElement();
                tCPEndpoint.host = string;
            }
        }
    }

    static void setDefaultPort(int n) {
        TCPEndpoint.setDefaultPort(n, null, null);
    }

    static void setDefaultPort(int n, RMIClientSocketFactory rMIClientSocketFactory, RMIServerSocketFactory rMIServerSocketFactory) {
        TCPEndpoint tCPEndpoint = TCPEndpoint.getLocalEndpoint(0, rMIClientSocketFactory, rMIServerSocketFactory);
        Hashtable hashtable = localEndpoints;
        synchronized (hashtable) {
            if (tCPEndpoint.port != 0) {
                return;
            }
            tCPEndpoint.port = n;
            TCPEndpoint tCPEndpoint2 = new TCPEndpoint(null, n, rMIClientSocketFactory, rMIServerSocketFactory);
            localEndpoints.put(tCPEndpoint2, tCPEndpoint);
            if (TCPTransport.logLevel >= 10) {
                LogStream.log("tcp").println("TCPEndpoint.setDefaultPort: default port for server socket factory " + rMIServerSocketFactory + " and client socket factory " + rMIClientSocketFactory + " set to " + n);
            }
        }
    }

    public Transport getTransport() {
        return this.getTransport(false);
    }

    private Transport getTransport(boolean bl) {
        if (bl) {
            return this.thisTransport;
        }
        TCPEndpoint tCPEndpoint = TCPEndpoint.getLocalEndpoint(0, this.csf, this.ssf);
        return tCPEndpoint.getTransport(true);
    }

    private static Collection allKnownTransports() {
        HashSet hashSet;
        Hashtable hashtable = localEndpoints;
        synchronized (hashtable) {
            hashSet = new HashSet(localEndpoints.size());
            Enumeration enumeration = localEndpoints.elements();
            while (enumeration.hasMoreElements()) {
                TCPEndpoint tCPEndpoint = (TCPEndpoint)enumeration.nextElement();
                hashSet.add(tCPEndpoint.thisTransport);
            }
        }
        return hashSet;
    }

    public static void shedConnectionCaches() {
        Iterator iterator = TCPEndpoint.allKnownTransports().iterator();
        while (iterator.hasNext()) {
            ((TCPTransport)iterator.next()).shedConnectionCaches();
        }
    }

    public void exportObject(Target target) throws RemoteException {
        Transport transport = this.getTransport(true);
        transport.exportObject(target);
    }

    public Channel getChannel() {
        Transport transport = this.getTransport(false);
        return transport.getChannel(this);
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public RMIClientSocketFactory getClientSocketFactory() {
        return this.csf;
    }

    public RMIServerSocketFactory getServerSocketFactory() {
        return this.ssf;
    }

    public String toString() {
        return "[" + this.host + ":" + this.port + (this.ssf != null ? "," + this.ssf : "") + (this.csf != null ? "," + this.csf : "") + "]";
    }

    public int hashCode() {
        return this.port;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof TCPEndpoint) {
            TCPEndpoint tCPEndpoint = (TCPEndpoint)object;
            if (this.port != tCPEndpoint.port || !this.host.equals(tCPEndpoint.host)) {
                return false;
            }
            if (this.csf == null ^ tCPEndpoint.csf == null || this.ssf == null ^ tCPEndpoint.ssf == null) {
                return false;
            }
            if (!(this.csf == null || this.csf.getClass() == tCPEndpoint.csf.getClass() && this.csf.equals(tCPEndpoint.csf))) {
                return false;
            }
            return this.ssf == null || this.ssf.getClass() == tCPEndpoint.ssf.getClass() && this.ssf.equals(tCPEndpoint.ssf);
        }
        return false;
    }

    public void write(ObjectOutput objectOutput) throws IOException {
        if (this.csf == null) {
            objectOutput.writeByte(0);
            objectOutput.writeUTF(this.host);
            objectOutput.writeInt(this.port);
        } else {
            objectOutput.writeByte(1);
            objectOutput.writeUTF(this.host);
            objectOutput.writeInt(this.port);
            objectOutput.writeObject(this.csf);
        }
    }

    public static TCPEndpoint read(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n;
        String string;
        RMIClientSocketFactory rMIClientSocketFactory = null;
        byte by = objectInput.readByte();
        switch (by) {
            case 0: {
                string = objectInput.readUTF();
                n = objectInput.readInt();
                break;
            }
            case 1: {
                string = objectInput.readUTF();
                n = objectInput.readInt();
                rMIClientSocketFactory = (RMIClientSocketFactory)objectInput.readObject();
                break;
            }
            default: {
                throw new IOException("invalid endpoint format");
            }
        }
        return new TCPEndpoint(string, n, rMIClientSocketFactory, null);
    }

    public void writeHostPortFormat(DataOutput dataOutput) throws IOException {
        if (this.csf != null) {
            throw new InternalError("TCPEndpoint.writeHostPortFormat: called for endpoint with non-null socket factory");
        }
        dataOutput.writeUTF(this.host);
        dataOutput.writeInt(this.port);
    }

    public static TCPEndpoint readHostPortFormat(DataInput dataInput) throws IOException {
        String string = dataInput.readUTF();
        int n = dataInput.readInt();
        return new TCPEndpoint(string, n);
    }

    private static RMISocketFactory chooseFactory() {
        RMISocketFactory rMISocketFactory = RMISocketFactory.getSocketFactory();
        if (rMISocketFactory == null) {
            rMISocketFactory = TCPTransport.defaultSocketFactory;
        }
        return rMISocketFactory;
    }

    Socket newSocket() throws RemoteException {
        Socket socket;
        if (TCPTransport.logLevel >= 20) {
            LogStream.log("tcp").println("TCPEndpoint.newSocket: opening socket to " + this);
        }
        try {
            RMIClientSocketFactory rMIClientSocketFactory = this.csf;
            if (rMIClientSocketFactory == null) {
                rMIClientSocketFactory = TCPEndpoint.chooseFactory();
            }
            socket = rMIClientSocketFactory.createSocket(this.host, this.port);
        }
        catch (UnknownHostException unknownHostException) {
            throw new java.rmi.UnknownHostException("Unknown host: " + this.host, unknownHostException);
        }
        catch (ConnectException connectException) {
            throw new java.rmi.ConnectException("Connection refused to host: " + this.host, connectException);
        }
        catch (IOException iOException) {
            try {
                TCPEndpoint.shedConnectionCaches();
            }
            catch (OutOfMemoryError outOfMemoryError) {
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new ConnectIOException("Exception creating connection to: " + this.host, iOException);
        }
        try {
            socket.setTcpNoDelay(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            socket.setKeepAlive(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return socket;
    }

    ServerSocket newServerSocket() throws IOException {
        if (TCPTransport.logLevel >= 20) {
            LogStream.log("tcp").println("TCPEndpoint.newServerSocket: creating server socket on " + this);
        }
        if (TCPEndpoint.getInt("sun.rmi.transport.tcp.simulateApplet", 0) >= 2) {
            throw new AppletSecurityException("socket.listen");
        }
        RMIServerSocketFactory rMIServerSocketFactory = this.ssf;
        if (rMIServerSocketFactory == null) {
            rMIServerSocketFactory = TCPEndpoint.chooseFactory();
        }
        ServerSocket serverSocket = rMIServerSocketFactory.createServerSocket(this.port);
        if (this.port == 0) {
            TCPEndpoint.setDefaultPort(serverSocket.getLocalPort(), this.csf, this.ssf);
        }
        return serverSocket;
    }

    static {
        localHostLock = new Object();
        localHostKnown = true;
        localHost = (String)AccessController.doPrivileged(new GetPropertyAction("java.rmi.server.hostname"));
        if (localHost == null) {
            try {
                InetAddress inetAddress = TCPEndpoint.getInt("sun.rmi.transport.tcp.simulateApplet", 0) >= 1 ? InetAddress.getByName("") : InetAddress.getLocalHost();
                byte[] byArray = inetAddress.getAddress();
                if (byArray[0] == 127 && byArray[1] == 0 && byArray[2] == 0 && byArray[3] == 1) {
                    localHostKnown = false;
                }
                localHost = TCPEndpoint.getBoolean("java.rmi.server.useLocalHostName") ? FQDN.attemptFQDN(inetAddress) : inetAddress.getHostAddress();
            }
            catch (Exception exception) {
                localHostKnown = false;
                localHost = null;
            }
        }
        if (TCPTransport.logLevel >= 10) {
            LogStream.log("tcp").println("TCPEndpoint.<clinit>: localHostKnown = " + localHostKnown + ", localHost = " + localHost);
        }
        localEndpoints = new Hashtable(3);
    }

    private static class FQDN
    implements Runnable {
        private String reverseLookup;
        private String hostAddress;

        private FQDN(String string) {
            this.hostAddress = string;
        }

        static String attemptFQDN(InetAddress inetAddress) throws UnknownHostException {
            String string = inetAddress.getHostName();
            if (string.indexOf(46) < 0) {
                String string2 = inetAddress.getHostAddress();
                FQDN fQDN = new FQDN(string2);
                int n = TCPEndpoint.getInt("sun.rmi.transport.tcp.localHostNameTimeOut", 10000);
                try {
                    FQDN fQDN2 = fQDN;
                    synchronized (fQDN2) {
                        fQDN.getFQDN();
                        fQDN.wait(n);
                    }
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
                string = fQDN.getHost();
                if (string == null || string.equals("") || string.indexOf(46) < 0) {
                    string = string2;
                }
            }
            return string;
        }

        private void getFQDN() {
            Thread thread = (Thread)AccessController.doPrivileged(new RMIThreadAction(this, "FQDN Finder", true));
            thread.start();
        }

        private synchronized String getHost() {
            return this.reverseLookup;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            FQDN fQDN;
            String string = null;
            try {
                try {
                    string = InetAddress.getByName(this.hostAddress).getHostName();
                }
                catch (UnknownHostException unknownHostException) {
                    Object var4_3 = null;
                    FQDN fQDN3 = this;
                    synchronized (fQDN3) {
                        this.reverseLookup = string;
                        this.notify();
                        return;
                    }
                }
                Object var4_2 = null;
                fQDN = this;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                FQDN fQDN2 = this;
                synchronized (fQDN2) {
                    this.reverseLookup = string;
                    this.notify();
                    throw throwable;
                }
            }
            synchronized (fQDN) {
                this.reverseLookup = string;
                this.notify();
                return;
            }
        }
    }
}

