/*
 * Decompiled with CFR 0.152.
 */
package jal.SHORT;

import jal.SHORT.BinaryOperator;

public final class Numeric {
    public static short accumulate(short[] sArray, int n, int n2, short s) {
        short s2 = s;
        while (n < n2) {
            s2 = (short)(s2 + sArray[n++]);
        }
        return s2;
    }

    public static short accumulate(short[] sArray, int n, int n2, short s, BinaryOperator binaryOperator) {
        short s2 = s;
        while (n < n2) {
            s2 = binaryOperator.apply(s2, sArray[n++]);
        }
        return s2;
    }

    public static short inner_product(short[] sArray, short[] sArray2, int n, int n2, int n3, short s) {
        short s2 = s;
        while (n < n2) {
            s2 = (short)(s2 + sArray[n++] * sArray2[n3++]);
        }
        return s2;
    }

    public static short inner_product(short[] sArray, short[] sArray2, int n, int n2, int n3, short s, BinaryOperator binaryOperator, BinaryOperator binaryOperator2) {
        short s2 = s;
        while (n < n2) {
            s2 = binaryOperator.apply(s2, binaryOperator2.apply(sArray[n++], sArray2[n3++]));
        }
        return s2;
    }

    public static int partial_sum(short[] sArray, short[] sArray2, int n, int n2, int n3) {
        if (n < n2) {
            sArray2[n3] = sArray[n];
            short s = sArray2[n3];
            while (++n < n2) {
                s = (short)(s + sArray[n]);
                sArray2[++n3] = s;
            }
            return n3 + 1;
        }
        return n3;
    }

    public static int partial_sum(short[] sArray, short[] sArray2, int n, int n2, int n3, BinaryOperator binaryOperator) {
        if (n < n2) {
            sArray2[n3] = sArray[n];
            short s = sArray2[n3];
            while (++n < n2) {
                s = binaryOperator.apply(s, sArray[n]);
                sArray2[++n3] = s;
            }
            return n3 + 1;
        }
        return n3;
    }

    public static int adjacent_difference(short[] sArray, short[] sArray2, int n, int n2, int n3) {
        if (n < n2) {
            sArray2[n3] = sArray[n];
            short s = sArray[n];
            while (++n < n2) {
                short s2 = sArray[n];
                sArray2[++n3] = (short)(s2 - s);
                s = s2;
            }
            return n3 + 1;
        }
        return n3;
    }

    public static int adjacent_difference(short[] sArray, short[] sArray2, int n, int n2, int n3, BinaryOperator binaryOperator) {
        if (n < n2) {
            sArray2[n3] = sArray[n];
            short s = sArray[n];
            while (++n < n2) {
                short s2 = sArray[n];
                sArray2[++n3] = binaryOperator.apply(s2, s);
                s = s2;
            }
            return n3 + 1;
        }
        return n3;
    }

    private Numeric() {
    }
}

