/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.linalg;

import cern.colt.list.IntArrayList;
import cern.colt.matrix.DoubleFactory1D;
import cern.colt.matrix.DoubleFactory2D;
import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.linalg.Algebra;
import cern.colt.matrix.linalg.Property;
import cern.jet.math.Mult;
import cern.jet.math.PlusMult;
import java.io.Serializable;

public class LUDecompositionQuick
implements Serializable {
    protected DoubleMatrix2D LU;
    protected int pivsign;
    protected int[] piv;
    protected boolean isNonSingular;
    protected Algebra algebra;
    protected transient double[] workDouble;
    protected transient int[] work1;
    protected transient int[] work2;

    public LUDecompositionQuick() {
        this(Property.DEFAULT.tolerance());
    }

    public LUDecompositionQuick(double d) {
        this.algebra = new Algebra(d);
    }

    public void decompose(DoubleMatrix2D doubleMatrix2D) {
        this.LU = doubleMatrix2D;
        int n = doubleMatrix2D.rows();
        int n2 = doubleMatrix2D.columns();
        if (this.piv == null || this.piv.length != n) {
            this.piv = new int[n];
        }
        int n3 = n;
        while (--n3 >= 0) {
            this.piv[n3] = n3;
        }
        this.pivsign = 1;
        if (n * n2 == 0) {
            this.setLU(this.LU);
            return;
        }
        DoubleMatrix1D[] doubleMatrix1DArray = new DoubleMatrix1D[n];
        int n4 = 0;
        while (n4 < n) {
            doubleMatrix1DArray[n4] = this.LU.viewRow(n4);
            ++n4;
        }
        IntArrayList intArrayList = new IntArrayList();
        DoubleMatrix1D doubleMatrix1D = this.LU.viewColumn(0).like();
        Mult mult = Mult.mult(0.0);
        int n5 = 0;
        while (n5 < n2) {
            double d;
            double d2;
            int n6;
            doubleMatrix1D.assign(this.LU.viewColumn(n5));
            doubleMatrix1D.getNonZeros(intArrayList, null);
            boolean bl = intArrayList.size() < n / 10;
            int n7 = 0;
            while (n7 < n) {
                n6 = Math.min(n7, n5);
                d2 = bl ? doubleMatrix1DArray[n7].zDotProduct(doubleMatrix1D, 0, n6, intArrayList) : doubleMatrix1DArray[n7].zDotProduct(doubleMatrix1D, 0, n6);
                d2 = doubleMatrix1D.getQuick(n7) - d2;
                doubleMatrix1D.setQuick(n7, d2);
                this.LU.setQuick(n7, n5, d2);
                ++n7;
            }
            n6 = n5;
            if (n6 < n) {
                d2 = Math.abs(doubleMatrix1D.getQuick(n6));
                int n8 = n5 + 1;
                while (n8 < n) {
                    double d3 = Math.abs(doubleMatrix1D.getQuick(n8));
                    if (d3 > d2) {
                        n6 = n8;
                        d2 = d3;
                    }
                    ++n8;
                }
            }
            if (n6 != n5) {
                doubleMatrix1DArray[n6].swap(doubleMatrix1DArray[n5]);
                int n9 = this.piv[n6];
                this.piv[n6] = this.piv[n5];
                this.piv[n5] = n9;
                this.pivsign = -this.pivsign;
            }
            if (n5 < n && (d = this.LU.getQuick(n5, n5)) != 0.0) {
                mult.multiplicator = 1.0 / d;
                this.LU.viewColumn(n5).viewPart(n5 + 1, n - (n5 + 1)).assign(mult);
            }
            ++n5;
        }
        this.setLU(this.LU);
    }

    public void decompose(DoubleMatrix2D doubleMatrix2D, int n) {
        if (!this.algebra.property().isSquare(doubleMatrix2D) || n < 0 || n > 2) {
            this.decompose(doubleMatrix2D);
            return;
        }
        this.LU = doubleMatrix2D;
        int n2 = doubleMatrix2D.rows();
        int n3 = doubleMatrix2D.columns();
        if (this.piv == null || this.piv.length != n2) {
            this.piv = new int[n2];
        }
        int n4 = n2;
        while (--n4 >= 0) {
            this.piv[n4] = n4;
        }
        this.pivsign = 1;
        if (n2 * n3 == 0) {
            this.setLU(doubleMatrix2D);
            return;
        }
        if (n == 2) {
            if (n3 > 1) {
                doubleMatrix2D.setQuick(1, 0, doubleMatrix2D.getQuick(1, 0) / doubleMatrix2D.getQuick(0, 0));
            }
            int n5 = 1;
            while (n5 < n3) {
                double d = doubleMatrix2D.getQuick(n5, n5) - doubleMatrix2D.getQuick(n5, n5 - 1) * doubleMatrix2D.getQuick(n5 - 1, n5);
                doubleMatrix2D.setQuick(n5, n5, d);
                if (n5 < n3 - 1) {
                    doubleMatrix2D.setQuick(n5 + 1, n5, doubleMatrix2D.getQuick(n5 + 1, n5) / d);
                }
                ++n5;
            }
        }
        this.setLU(doubleMatrix2D);
    }

    public double det() {
        int n;
        int n2 = this.m();
        if (n2 != (n = this.n())) {
            throw new IllegalArgumentException("Matrix must be square.");
        }
        if (!this.isNonsingular()) {
            return 0.0;
        }
        double d = this.pivsign;
        int n3 = 0;
        while (n3 < n) {
            d *= this.LU.getQuick(n3, n3);
            ++n3;
        }
        return d;
    }

    protected double[] getDoublePivot() {
        int n = this.m();
        double[] dArray = new double[n];
        int n2 = 0;
        while (n2 < n) {
            dArray[n2] = this.piv[n2];
            ++n2;
        }
        return dArray;
    }

    public DoubleMatrix2D getL() {
        return this.lowerTriangular(this.LU.copy());
    }

    public DoubleMatrix2D getLU() {
        return this.LU.copy();
    }

    public int[] getPivot() {
        return this.piv;
    }

    public DoubleMatrix2D getU() {
        return this.upperTriangular(this.LU.copy());
    }

    public boolean isNonsingular() {
        return this.isNonSingular;
    }

    protected boolean isNonsingular(DoubleMatrix2D doubleMatrix2D) {
        int n = doubleMatrix2D.rows();
        int n2 = doubleMatrix2D.columns();
        double d = this.algebra.property().tolerance();
        int n3 = Math.min(n2, n);
        while (--n3 >= 0) {
            if (!(Math.abs(doubleMatrix2D.getQuick(n3, n3)) <= d)) continue;
            return false;
        }
        return true;
    }

    protected DoubleMatrix2D lowerTriangular(DoubleMatrix2D doubleMatrix2D) {
        int n;
        int n2 = doubleMatrix2D.rows();
        int n3 = doubleMatrix2D.columns();
        int n4 = n = Math.min(n2, n3);
        while (--n4 >= 0) {
            int n5 = n;
            while (--n5 >= 0) {
                if (n4 < n5) {
                    doubleMatrix2D.setQuick(n4, n5, 0.0);
                    continue;
                }
                if (n4 != n5) continue;
                doubleMatrix2D.setQuick(n4, n5, 1.0);
            }
        }
        if (n3 > n2) {
            doubleMatrix2D.viewPart(0, n, n2, n3 - n).assign(0.0);
        }
        return doubleMatrix2D;
    }

    protected int m() {
        return this.LU.rows();
    }

    protected int n() {
        return this.LU.columns();
    }

    public void setLU(DoubleMatrix2D doubleMatrix2D) {
        this.LU = doubleMatrix2D;
        this.isNonSingular = this.isNonsingular(doubleMatrix2D);
    }

    public void solve(DoubleMatrix1D doubleMatrix1D) {
        this.algebra.property().checkRectangular(this.LU);
        int n = this.m();
        int n2 = this.n();
        if (doubleMatrix1D.size() != n) {
            throw new IllegalArgumentException("Matrix dimensions must agree.");
        }
        if (!this.isNonsingular()) {
            throw new IllegalArgumentException("Matrix is singular.");
        }
        if (this.workDouble == null || this.workDouble.length < n) {
            this.workDouble = new double[n];
        }
        this.algebra.permute(doubleMatrix1D, this.piv, this.workDouble);
        if (n * n2 == 0) {
            return;
        }
        int n3 = 0;
        while (n3 < n2) {
            double d = doubleMatrix1D.getQuick(n3);
            if (d != 0.0) {
                int n4 = n3 + 1;
                while (n4 < n2) {
                    double d2 = this.LU.getQuick(n4, n3);
                    if (d2 != 0.0) {
                        doubleMatrix1D.setQuick(n4, doubleMatrix1D.getQuick(n4) - d * d2);
                    }
                    ++n4;
                }
            }
            ++n3;
        }
        int n5 = n2 - 1;
        while (n5 >= 0) {
            doubleMatrix1D.setQuick(n5, doubleMatrix1D.getQuick(n5) / this.LU.getQuick(n5, n5));
            double d = doubleMatrix1D.getQuick(n5);
            if (d != 0.0) {
                int n6 = 0;
                while (n6 < n5) {
                    double d3 = this.LU.getQuick(n6, n5);
                    if (d3 != 0.0) {
                        doubleMatrix1D.setQuick(n6, doubleMatrix1D.getQuick(n6) - d * d3);
                    }
                    ++n6;
                }
            }
            --n5;
        }
    }

    public void solve(DoubleMatrix2D doubleMatrix2D) {
        int n;
        int n2;
        int n3;
        int n4;
        this.algebra.property().checkRectangular(this.LU);
        int n5 = this.m();
        int n6 = this.n();
        if (doubleMatrix2D.rows() != n5) {
            throw new IllegalArgumentException("Matrix row dimensions must agree.");
        }
        if (!this.isNonsingular()) {
            throw new IllegalArgumentException("Matrix is singular.");
        }
        if (this.work1 == null || this.work1.length < n5) {
            this.work1 = new int[n5];
        }
        this.algebra.permuteRows(doubleMatrix2D, this.piv, this.work1);
        if (n5 * n6 == 0) {
            return;
        }
        int n7 = doubleMatrix2D.columns();
        DoubleMatrix1D[] doubleMatrix1DArray = new DoubleMatrix1D[n6];
        int n8 = 0;
        while (n8 < n6) {
            doubleMatrix1DArray[n8] = doubleMatrix2D.viewRow(n8);
            ++n8;
        }
        Mult mult = Mult.div(0.0);
        PlusMult plusMult = PlusMult.minusMult(0.0);
        IntArrayList intArrayList = new IntArrayList();
        DoubleMatrix1D doubleMatrix1D = DoubleFactory1D.dense.make(n7);
        int n9 = 0;
        while (n9 < n6) {
            doubleMatrix1D.assign(doubleMatrix1DArray[n9]);
            n4 = n7 / 10;
            doubleMatrix1D.getNonZeros(intArrayList, null, n4);
            n3 = intArrayList.size();
            n2 = n3 < n4 ? 1 : 0;
            n = n9 + 1;
            while (n < n6) {
                plusMult.multiplicator = -this.LU.getQuick(n, n9);
                if (plusMult.multiplicator != 0.0) {
                    if (n2 != 0) {
                        doubleMatrix1DArray[n].assign(doubleMatrix1D, plusMult, intArrayList);
                    } else {
                        doubleMatrix1DArray[n].assign(doubleMatrix1D, plusMult);
                    }
                }
                ++n;
            }
            ++n9;
        }
        n4 = n6 - 1;
        while (n4 >= 0) {
            mult.multiplicator = 1.0 / this.LU.getQuick(n4, n4);
            doubleMatrix1DArray[n4].assign(mult);
            if (doubleMatrix1D == null) {
                doubleMatrix1D = DoubleFactory1D.dense.make(doubleMatrix2D.columns());
            }
            doubleMatrix1D.assign(doubleMatrix1DArray[n4]);
            n3 = n7 / 10;
            doubleMatrix1D.getNonZeros(intArrayList, null, n3);
            n2 = intArrayList.size();
            n = n2 < n3 ? 1 : 0;
            int n10 = 0;
            while (n10 < n4) {
                plusMult.multiplicator = -this.LU.getQuick(n10, n4);
                if (plusMult.multiplicator != 0.0) {
                    if (n != 0) {
                        doubleMatrix1DArray[n10].assign(doubleMatrix1D, plusMult, intArrayList);
                    } else {
                        doubleMatrix1DArray[n10].assign(doubleMatrix1D, plusMult);
                    }
                }
                ++n10;
            }
            --n4;
        }
    }

    private void solveOld(DoubleMatrix2D doubleMatrix2D) {
        int n;
        double d;
        int n2;
        this.algebra.property().checkRectangular(this.LU);
        int n3 = this.m();
        int n4 = this.n();
        if (doubleMatrix2D.rows() != n3) {
            throw new IllegalArgumentException("Matrix row dimensions must agree.");
        }
        if (!this.isNonsingular()) {
            throw new IllegalArgumentException("Matrix is singular.");
        }
        int n5 = doubleMatrix2D.columns();
        if (this.work1 == null || this.work1.length < n3) {
            this.work1 = new int[n3];
        }
        this.algebra.permuteRows(doubleMatrix2D, this.piv, this.work1);
        int n6 = 0;
        while (n6 < n4) {
            n2 = n6 + 1;
            while (n2 < n4) {
                d = this.LU.getQuick(n2, n6);
                if (d != 0.0) {
                    n = 0;
                    while (n < n5) {
                        doubleMatrix2D.setQuick(n2, n, doubleMatrix2D.getQuick(n2, n) - doubleMatrix2D.getQuick(n6, n) * d);
                        ++n;
                    }
                }
                ++n2;
            }
            ++n6;
        }
        n2 = n4 - 1;
        while (n2 >= 0) {
            d = 1.0 / this.LU.getQuick(n2, n2);
            if (d != 1.0) {
                n = 0;
                while (n < n5) {
                    doubleMatrix2D.setQuick(n2, n, doubleMatrix2D.getQuick(n2, n) * d);
                    ++n;
                }
            }
            n = 0;
            while (n < n2) {
                d = this.LU.getQuick(n, n2);
                if (d != 0.0) {
                    int n7 = 0;
                    while (n7 < n5) {
                        doubleMatrix2D.setQuick(n, n7, doubleMatrix2D.getQuick(n, n7) - doubleMatrix2D.getQuick(n2, n7) * d);
                        ++n7;
                    }
                }
                ++n;
            }
            --n2;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = "Illegal operation or error: ";
        stringBuffer.append("-----------------------------------------------------------------------------\n");
        stringBuffer.append("LUDecompositionQuick(A) --> isNonSingular(A), det(A), pivot, L, U, inverse(A)\n");
        stringBuffer.append("-----------------------------------------------------------------------------\n");
        stringBuffer.append("isNonSingular = ");
        try {
            stringBuffer.append(String.valueOf(this.isNonsingular()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            stringBuffer.append(string + illegalArgumentException.getMessage());
        }
        stringBuffer.append("\ndet = ");
        try {
            stringBuffer.append(String.valueOf(this.det()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            stringBuffer.append(string + illegalArgumentException.getMessage());
        }
        stringBuffer.append("\npivot = ");
        try {
            stringBuffer.append(String.valueOf(new IntArrayList(this.getPivot())));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            stringBuffer.append(string + illegalArgumentException.getMessage());
        }
        stringBuffer.append("\n\nL = ");
        try {
            stringBuffer.append(String.valueOf(this.getL()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            stringBuffer.append(string + illegalArgumentException.getMessage());
        }
        stringBuffer.append("\n\nU = ");
        try {
            stringBuffer.append(String.valueOf(this.getU()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            stringBuffer.append(string + illegalArgumentException.getMessage());
        }
        stringBuffer.append("\n\ninverse(A) = ");
        DoubleMatrix2D doubleMatrix2D = DoubleFactory2D.dense.identity(this.LU.rows());
        try {
            this.solve(doubleMatrix2D);
            stringBuffer.append(String.valueOf(doubleMatrix2D));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            stringBuffer.append(string + illegalArgumentException.getMessage());
        }
        return stringBuffer.toString();
    }

    protected DoubleMatrix2D upperTriangular(DoubleMatrix2D doubleMatrix2D) {
        int n;
        int n2 = doubleMatrix2D.rows();
        int n3 = doubleMatrix2D.columns();
        int n4 = n = Math.min(n2, n3);
        while (--n4 >= 0) {
            int n5 = n;
            while (--n5 >= 0) {
                if (n4 <= n5) continue;
                doubleMatrix2D.setQuick(n4, n5, 0.0);
            }
        }
        if (n3 < n2) {
            doubleMatrix2D.viewPart(n, 0, n2 - n, n3).assign(0.0);
        }
        return doubleMatrix2D;
    }

    private double[] xgetDoublePivot() {
        int n = this.m();
        double[] dArray = new double[n];
        int n2 = 0;
        while (n2 < n) {
            dArray[n2] = this.piv[n2];
            ++n2;
        }
        return dArray;
    }
}

