/*
 * Decompiled with CFR 0.152.
 */
import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.FileOutputStream;
import java.io.OutputStream;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class MapFrame
extends JFrame {
    private MapLabel keggLabel;
    private JPanel mapPanel;
    private JScrollPane mapScrollPane;
    private Icon mapIconImage;
    private BufferedImage currentMapImage;

    public MapFrame(BufferedImage bufferedImage, Graphics2D graphics2D) {
        this.currentMapImage = bufferedImage;
        this.setTitle(new String("Map Manipulation Area for KEGG map " + KEGGData.map));
        ((Component)this).setSize(300, 300);
        this.mapPanel = new JPanel();
        this.mapPanel.setLayout(new BorderLayout());
        this.getContentPane().add(this.mapPanel);
        this.keggLabel = new MapLabel(new ImageIcon(bufferedImage));
        this.keggLabel.mapGraphicsForJPEG = graphics2D;
        this.keggLabel.addMouseListener(new MouseAdapter(){

            public synchronized void mousePressed(MouseEvent mouseEvent) {
                ((MapFrame)MapFrame.this).keggLabel.mouseX = mouseEvent.getX();
                ((MapFrame)MapFrame.this).keggLabel.mouseY = mouseEvent.getY();
                CheckForClickedGene.setVectorInformation(MapFrame.this.keggLabel);
                MapFrame.this.keggLabel.redrawMap();
            }

            public synchronized void mouseReleased(MouseEvent mouseEvent) {
                CheckForClickedGene.isItAGene = false;
                MapFrame.this.keggLabel.redrawMap();
            }
        });
        this.keggLabel.addMouseMotionListener(new MouseMotionAdapter(){

            public synchronized void mouseDragged(MouseEvent mouseEvent) {
                if (CheckForClickedGene.isItAGene) {
                    KEGGData.multipleGenes_X.setElementAt(Integer.toString(mouseEvent.getX()), CheckForClickedGene.geneIndexInVector);
                    KEGGData.multipleGenes_Y.setElementAt(Integer.toString(mouseEvent.getY()), CheckForClickedGene.geneIndexInVector);
                    MapFrame.this.keggLabel.redrawMap();
                }
            }
        });
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                MapFrame.this.keggLabel.paintMapGraphics();
                try {
                    JPEGImageEncoder jPEGImageEncoder = JPEGCodec.createJPEGEncoder((OutputStream)new FileOutputStream(SystemData.path + KEGGData.map_path + KEGGData.map + " " + "output.jpg"));
                    jPEGImageEncoder.encode(MapFrame.this.currentMapImage);
                    jPEGImageEncoder.getOutputStream().close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                KEGGData.resetKEGGData();
                KEGGData.current_Present_Model.WorkingStatus.setText("Job done.  Waiting for process request.");
                KEGGData.current_Present_Model.RunButton.setEnabled(true);
                KEGGData.current_Present_Model.update(((Component)KEGGData.current_Present_Model).getGraphics());
            }
        });
        this.mapScrollPane = new JScrollPane();
        this.mapScrollPane.getViewport().add(this.keggLabel);
        this.mapPanel.add((Component)this.mapScrollPane, "Center");
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                if ((int)MapFrame.this.getSize().getWidth() > KEGGData.mapWidth && (int)MapFrame.this.getSize().getHeight() > KEGGData.mapHeight) {
                    ((Component)MapFrame.this).setSize(KEGGData.mapWidth, KEGGData.mapHeight);
                } else if ((int)MapFrame.this.getSize().getWidth() > KEGGData.mapWidth) {
                    ((Component)MapFrame.this).setSize(KEGGData.mapWidth, (int)MapFrame.this.getSize().getHeight());
                } else if ((int)MapFrame.this.getSize().getHeight() > KEGGData.mapHeight) {
                    ((Component)MapFrame.this).setSize((int)MapFrame.this.getSize().getWidth(), KEGGData.mapHeight);
                }
            }
        });
        ((Component)this).setSize(KEGGData.mapWidth / 3, KEGGData.mapHeight / 3);
        ((Component)this).setVisible(true);
    }
}

