/*
 * Decompiled with CFR 0.152.
 */
import cern.jet.random.AbstractDistribution;
import cern.jet.random.HyperGeometric;

public class Pathway_Summary_Calculator {
    private static boolean isAverageWithinPathwayExistent;
    private static boolean isAverageOutsidePathwayExistent;

    public static double get_Fisher_Exact_Test(double d, double d2, double d3, double d4) {
        double d5 = 0.0;
        HyperGeometric hyperGeometric = new HyperGeometric((int)d2, (int)d3, (int)d, AbstractDistribution.makeDefaultGenerator());
        int n = (int)d4;
        while ((double)n <= d) {
            d5 += hyperGeometric.pdf(n);
            ++n;
        }
        return d5;
    }

    public static double get_LRT(double d, double d2, double d3, double d4) {
        double d5 = 0.0;
        try {
            d5 = Math.pow(d3 / d, d3) * Math.pow(1.0 - d3 / d, d - d3) / (Math.pow(d4 / d2, d3) * Math.pow(1.0 - d4 / d2, d - d3));
            d5 = 2.0 * Math.log(d5);
        }
        catch (ArithmeticException arithmeticException) {
            d5 = 0.0;
        }
        return d5;
    }

    public static double get_average_inside_outside(int n) {
        double d = 0.0;
        double d2 = Pathway_Summary_Calculator.get_average_within_pathway(n);
        double d3 = Pathway_Summary_Calculator.get_average_outside_pathway(n);
        d = isAverageWithinPathwayExistent && isAverageOutsidePathwayExistent ? d2 - d3 : 0.0;
        return d;
    }

    public static double get_t_test(int n, double d, double d2) {
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = 0.0;
        d4 = Pathway_Summary_Calculator.get_average_within_pathway(n);
        d5 = Pathway_Summary_Calculator.get_average_outside_pathway(n);
        if (isAverageWithinPathwayExistent && isAverageOutsidePathwayExistent) {
            d6 = Pathway_Summary_Calculator.get_variance_within_pathway(n);
            d7 = Pathway_Summary_Calculator.get_variance_outside_pathway(n);
            try {
                d3 = (d4 - d5) / Math.sqrt(d6 / d + d7 / (d2 - d));
            }
            catch (ArithmeticException arithmeticException) {
                d3 = 0.0;
            }
            if (Double.toString(d3).equals("NaN")) {
                d3 = 0.0;
            }
            if (Double.toString(Math.abs(d3)).equals("Infinity")) {
                d3 = 0.0;
            }
            if (d6 == 0.0 || d7 == 0.0) {
                d3 = 0.0;
            }
        } else {
            d3 = 0.0;
        }
        return d3;
    }

    public static double get_unsigned_t_test(int n, double d, double d2) {
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = 0.0;
        d4 = Pathway_Summary_Calculator.get_unsigned_average_within_pathway(n);
        d5 = Pathway_Summary_Calculator.get_unsigned_average_outside_pathway(n);
        if (isAverageWithinPathwayExistent && isAverageOutsidePathwayExistent) {
            d6 = Pathway_Summary_Calculator.get_unsigned_variance_within_pathway(n);
            d7 = Pathway_Summary_Calculator.get_unsigned_variance_outside_pathway(n);
            try {
                d3 = (d4 - d5) / Math.sqrt(d6 / d + d7 / (d2 - d));
            }
            catch (ArithmeticException arithmeticException) {
                d3 = 0.0;
            }
            if (Double.toString(d3).equals("NaN")) {
                d3 = 0.0;
            }
            if (Double.toString(Math.abs(d3)).equals("Infinity")) {
                d3 = 0.0;
            }
            if (d6 == 0.0 || d7 == 0.0) {
                d3 = 0.0;
            }
        } else {
            d3 = 0.0;
        }
        return d3;
    }

    private static double get_average_within_pathway(int n) {
        double d;
        double d2 = 0.0;
        double d3 = 0.0;
        int n2 = 0;
        while (n2 < PathwayData.foldchanges_perPathway[n].size()) {
            d3 = Double.valueOf(((String)PathwayData.foldchanges_perPathway[n].elementAt(n2)).trim());
            d3 = Log_FoldChange_Converter.convertFoldChange(d3);
            d2 += d3;
            ++n2;
        }
        isAverageWithinPathwayExistent = true;
        try {
            d = d2 / (double)PathwayData.foldchanges_perPathway[n].size();
        }
        catch (ArithmeticException arithmeticException) {
            isAverageWithinPathwayExistent = false;
            d = 0.0;
        }
        if (Double.toString(d).equals("NaN")) {
            isAverageWithinPathwayExistent = false;
        }
        if (Double.toString(d).equals("Infinity")) {
            isAverageWithinPathwayExistent = false;
            d = 0.0;
        }
        return d;
    }

    private static double get_average_outside_pathway(int n) {
        double d;
        double d2 = 0.0;
        double d3 = 0.0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < PathwayData.vector_of_all_genenames_beyond_cutoff.size()) {
            String string = new String((String)PathwayData.vector_of_all_genenames_beyond_cutoff.elementAt(n3));
            boolean bl = false;
            int n4 = 0;
            while (n4 < PathwayData.genenames_perPathway[n].size()) {
                if (((String)PathwayData.genenames_perPathway[n].elementAt(n4)).equalsIgnoreCase(string)) {
                    bl = true;
                }
                ++n4;
            }
            if (!bl) {
                double d4 = Double.valueOf(((String)PathwayData.vector_of_all_foldchanges_beyond_cutoff.elementAt(n3)).trim());
                d2 += Log_FoldChange_Converter.convertFoldChange(d4);
                ++n2;
            }
            ++n3;
        }
        isAverageOutsidePathwayExistent = true;
        try {
            d = d2 / (double)n2;
        }
        catch (ArithmeticException arithmeticException) {
            isAverageOutsidePathwayExistent = false;
            d = 0.0;
        }
        if (Double.toString(d).equals("NaN")) {
            isAverageOutsidePathwayExistent = false;
        }
        if (Double.toString(d).equals("Infinity")) {
            isAverageOutsidePathwayExistent = false;
            d = 0.0;
        }
        return d;
    }

    private static double get_variance_within_pathway(int n) {
        double d = 0.0;
        d = Pathway_Summary_Calculator.get_average_within_pathway(n);
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        int n2 = 0;
        while (n2 < PathwayData.foldchanges_perPathway[n].size()) {
            d4 = Double.valueOf(((String)PathwayData.foldchanges_perPathway[n].elementAt(n2)).trim());
            d4 = Log_FoldChange_Converter.convertFoldChange(d4);
            d3 += Math.pow(d4 - d, 2.0);
            ++n2;
        }
        d2 = d3 / (double)(PathwayData.foldchanges_perPathway[n].size() - 1);
        if (Double.toString(d2).equals("NaN")) {
            d2 = 0.0;
        }
        return d2;
    }

    private static double get_variance_outside_pathway(int n) {
        double d = 0.0;
        d = Pathway_Summary_Calculator.get_average_outside_pathway(n);
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < PathwayData.vector_of_all_genenames_beyond_cutoff.size()) {
            String string = new String((String)PathwayData.vector_of_all_genenames_beyond_cutoff.elementAt(n3));
            boolean bl = false;
            int n4 = 0;
            while (n4 < PathwayData.genenames_perPathway[n].size()) {
                if (((String)PathwayData.genenames_perPathway[n].elementAt(n4)).equalsIgnoreCase(string)) {
                    bl = true;
                }
                ++n4;
            }
            if (!bl) {
                d4 = Double.valueOf(((String)PathwayData.vector_of_all_foldchanges_beyond_cutoff.elementAt(n3)).trim());
                d4 = Log_FoldChange_Converter.convertFoldChange(d4);
                d3 += Math.pow(d4 - d, 2.0);
                ++n2;
            }
            ++n3;
        }
        d2 = d3 / (double)(n2 - 1);
        if (Double.toString(d2).equals("NaN")) {
            d2 = 0.0;
        }
        return d2;
    }

    private static double get_unsigned_average_within_pathway(int n) {
        double d = 0.0;
        double d2 = 0.0;
        int n2 = 0;
        while (n2 < PathwayData.foldchanges_perPathway[n].size()) {
            d2 = Double.valueOf(((String)PathwayData.foldchanges_perPathway[n].elementAt(n2)).trim());
            d2 = Unsigned_Converter.convertToUnsigned_Ratio(d2);
            d2 = Log_FoldChange_Converter.convertFoldChange(d2);
            d += d2;
            ++n2;
        }
        double d3 = d / (double)PathwayData.foldchanges_perPathway[n].size();
        isAverageWithinPathwayExistent = true;
        if (Double.toString(d3).equals("NaN")) {
            isAverageWithinPathwayExistent = false;
        }
        return d3;
    }

    private static double get_unsigned_average_outside_pathway(int n) {
        double d = 0.0;
        double d2 = 0.0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < PathwayData.vector_of_all_genenames_beyond_cutoff.size()) {
            String string = new String((String)PathwayData.vector_of_all_genenames_beyond_cutoff.elementAt(n3));
            boolean bl = false;
            int n4 = 0;
            while (n4 < PathwayData.genenames_perPathway[n].size()) {
                if (((String)PathwayData.genenames_perPathway[n].elementAt(n4)).equalsIgnoreCase(string)) {
                    bl = true;
                }
                ++n4;
            }
            if (!bl) {
                double d3 = Double.valueOf(((String)PathwayData.vector_of_all_foldchanges_beyond_cutoff.elementAt(n3)).trim());
                d += Log_FoldChange_Converter.convertFoldChange(Unsigned_Converter.convertToUnsigned_Ratio(d3));
                ++n2;
            }
            ++n3;
        }
        double d4 = d / (double)n2;
        isAverageOutsidePathwayExistent = true;
        if (Double.toString(d4).equals("NaN")) {
            isAverageOutsidePathwayExistent = false;
        }
        return d4;
    }

    private static double get_unsigned_variance_within_pathway(int n) {
        double d = 0.0;
        d = Pathway_Summary_Calculator.get_average_within_pathway(n);
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        int n2 = 0;
        while (n2 < PathwayData.foldchanges_perPathway[n].size()) {
            d4 = Double.valueOf(((String)PathwayData.foldchanges_perPathway[n].elementAt(n2)).trim());
            d4 = Unsigned_Converter.convertToUnsigned_Ratio(d4);
            d4 = Log_FoldChange_Converter.convertFoldChange(d4);
            d3 += Math.pow(d4 - d, 2.0);
            ++n2;
        }
        d2 = d3 / (double)(PathwayData.foldchanges_perPathway[n].size() - 1);
        if (Double.toString(d2).equals("NaN")) {
            d2 = 0.0;
        }
        return d2;
    }

    private static double get_unsigned_variance_outside_pathway(int n) {
        double d = 0.0;
        d = Pathway_Summary_Calculator.get_average_outside_pathway(n);
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < PathwayData.vector_of_all_genenames_beyond_cutoff.size()) {
            String string = new String((String)PathwayData.vector_of_all_genenames_beyond_cutoff.elementAt(n3));
            boolean bl = false;
            int n4 = 0;
            while (n4 < PathwayData.genenames_perPathway[n].size()) {
                if (((String)PathwayData.genenames_perPathway[n].elementAt(n4)).equalsIgnoreCase(string)) {
                    bl = true;
                }
                ++n4;
            }
            if (!bl) {
                d4 = Double.valueOf(((String)PathwayData.vector_of_all_foldchanges_beyond_cutoff.elementAt(n3)).trim());
                d4 = Unsigned_Converter.convertToUnsigned_Ratio(d4);
                d4 = Log_FoldChange_Converter.convertFoldChange(d4);
                d3 += Math.pow(d4 - d, 2.0);
                ++n2;
            }
            ++n3;
        }
        d2 = d3 / (double)(n2 - 1);
        if (Double.toString(d2).equals("NaN")) {
            d2 = 0.0;
        }
        return d2;
    }
}

