/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref;

import hep.aida.IHistogram1D;
import hep.aida.IHistogram2D;
import hep.aida.IHistogram3D;
import hep.aida.ref.Converter;
import hep.aida.ref.Histogram1D;
import hep.aida.ref.Histogram2D;
import hep.aida.ref.Histogram3D;
import hep.aida.ref.VariableAxis;
import java.util.Random;

public class Test2 {
    public static void main(String[] stringArray) {
        Random random = new Random();
        Histogram1D histogram1D = new Histogram1D("AIDA 1D Histogram", 40, -3.0, 3.0);
        int n = 0;
        while (n < 10000) {
            histogram1D.fill(random.nextGaussian());
            ++n;
        }
        Histogram2D histogram2D = new Histogram2D("AIDA 2D Histogram", 40, -3.0, 3.0, 40, -3.0, 3.0);
        int n2 = 0;
        while (n2 < 10000) {
            histogram2D.fill(random.nextGaussian(), random.nextGaussian());
            ++n2;
        }
        Test2.writeAsXML(histogram1D, "aida1.xml");
        Test2.writeAsXML(histogram2D, "aida2.xml");
        Test2.writeAsXML(histogram2D.projectionX(), "projectionX.xml");
        Test2.writeAsXML(histogram2D.projectionY(), "projectionY.xml");
    }

    public static void main2(String[] stringArray) {
        double[] dArray = new double[]{-30.0, 0.0, 30.0, 1000.0};
        Random random = new Random();
        Histogram1D histogram1D = new Histogram1D("AIDA 1D Histogram", new VariableAxis(dArray));
        int n = 0;
        while (n < 10000) {
            histogram1D.fill(random.nextGaussian());
            ++n;
        }
        Histogram2D histogram2D = new Histogram2D("AIDA 2D Histogram", new VariableAxis(dArray), new VariableAxis(dArray));
        int n2 = 0;
        while (n2 < 10000) {
            histogram2D.fill(random.nextGaussian(), random.nextGaussian());
            ++n2;
        }
        Histogram3D histogram3D = new Histogram3D("AIDA 3D Histogram", 10, -2.0, 2.0, 5, -2.0, 2.0, 3, -2.0, 2.0);
        int n3 = 0;
        while (n3 < 10000) {
            histogram3D.fill(random.nextGaussian(), random.nextGaussian(), random.nextGaussian());
            ++n3;
        }
        Test2.writeAsXML(histogram1D, "aida1.xml");
        Test2.writeAsXML(histogram2D, "aida2.xml");
        Test2.writeAsXML(histogram3D, "aida2.xml");
        Test2.writeAsXML(histogram2D.projectionX(), "projectionX.xml");
        Test2.writeAsXML(histogram2D.projectionY(), "projectionY.xml");
    }

    private static void writeAsXML(IHistogram1D iHistogram1D, String string) {
        System.out.println(new Converter().toString(iHistogram1D));
    }

    private static void writeAsXML(IHistogram2D iHistogram2D, String string) {
        System.out.println(new Converter().toString(iHistogram2D));
    }

    private static void writeAsXML(IHistogram3D iHistogram3D, String string) {
        System.out.println(new Converter().toString(iHistogram3D));
    }
}

